<?php

namespace ModulesGarden\GSuite\App\Models;

use \Illuminate\Database\Eloquent\model as EloquentModel;
use \Illuminate\Database\Schema\Blueprint;
use \WHMCS\Database\Capsule;

/**
 * Description of GSuiteToken
 * 
 * @var int product_id
 * @var text oauth_clientid
 * @var text oauth_clientsecret
 * @var text token
 * @var text token_life
 * @var text update_time
 * 
 * @author Sławomir Miśkowicz <slawomir@modulesgarden.com>
 */
class GSuiteToken extends EloquentModel
{
    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'MG_gSuite_tokens';

    /**
     * Eloquent fillable parameters
     * @var array
     */
    protected $fillable = ['product_id', 'oauth_clientid', 'oauth_clientsecret', 'token', 'token_life', 'update_time', 'refresh_token'];

    public function tableExists()
    {
        return Capsule::Schema()->hasTable($this->table);
    }

    protected function createTable()
    {
        Capsule::schema()->create($this->table, function (Blueprint $table)
        {
            $table->charset   = 'utf8';
            $table->collation = 'utf8_unicode_ci';

            $table->unsignedInteger('product_id', false);
            $table->text('oauth_clientid');
            $table->text('oauth_clientsecret');
            $table->text('token');
            $table->text('token_life');
            $table->text('update_time');
            $table->text('refresh_token');

            $table->unique('product_id');
        });
    }

    public function createTableIfNotExists()
    {
        if (!$this->tableExists())
        {
            $this->createTable();
        }
    }

    public function scopeWhereProductId($productId)
    {
        return $this->where("product_id", $productId)->first();
    }

    public function updateAccessToken($productId, $token, $tokenLife)
    {
        $this->where('product_id', $productId)
                ->updateOrInsert(['product_id' => $productId], [
                    'token'       => $token,
                    'token_life'  => $tokenLife,
                    'update_time' => \time()
                ]);
    }

    public function unsetAccessToken($productId)
    {
        $this->where('product_id', $productId)->updateOrInsert(['product_id' => $productId], ['token' => '']);
    }

    public function updateRefreshToken($productId, $refreshToken)
    {
        $this->where('product_id', $productId)->updateOrInsert(['product_id' => $productId], ['refresh_token' => $refreshToken]);
    }

    public function unsetRefreshToken($productId)
    {
        $this->where('product_id', $productId)->updateOrInsert(['product_id' => $productId], ['refresh_token' => '']);
    }

    public function updateOauthClientDetails($productId, $clientId, $clientSecret)
    {
        $this->where('product_id', $productId)
                ->updateOrInsert(['product_id' => $productId], [
                    'oauth_clientid'     => $clientId,
                    'oauth_clientsecret' => $clientSecret
                ]);
    }
}
