<?php

/* * ********************************************************************
 * DomainAndEmailForwarding product developed. (2016-06-30)
 * *
 *
 *  CREATED BY MODULESGARDEN       ->       http://modulesgarden.com
 *  CONTACT                        ->       contact@modulesgarden.com
 *
 *
 * This software is furnished under a license and may be used and copied
 * only  in  accordance  with  the  terms  of such  license and with the
 * inclusion of the above copyright notice.  This software  or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person.  No title to and  ownership of the  software is  hereby
 * transferred.
 *
 *
 * ******************************************************************** */

namespace MGModule\DomainAndEmailForwarding\models;

use MGModule\DomainAndEmailForwarding as main;

/**
 * Description of Submodule
 *
 * @author Pawel Kopec <pawelk@modulesgarden.com>
 * @Table(name=submodules)
 */
class SubmoduleConfiguration extends main\mgLibs\models\Orm
{
    /**
     * ID field
     * 
     * @Column(id)
     * @var int 
     */
    protected $id;

    /**
     * @Column(name=name)
     * @var string
     */
    protected $name;

    /**
     * @Column(name=class,as=className)
     * @var string
     */
    protected $className;

    /**
     * @Column(name=version)
     * @var string
     */
    protected $version;

    /**
     * @Column(boolean,name=active)
     * @var boolean
     */
    protected $active;

    /**
     * @Column(name=options)
     * @var array
     */
    protected $options;

    public function getId()
    {
        return $this->id;
    }

    public function getName()
    {
        return $this->name;
    }

    public function getClassName()
    {
        return $this->className;
    }

    public function getVersion()
    {
        return $this->version;
    }

    public function isActive()
    {
        return $this->active == "1";
    }

    public function getOptions()
    {
        return json_decode($this->options, true);
    }

    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }

    public function setName($name)
    {
        $this->name = $name;
        return $this;
    }

    public function setClassName($className)
    {
        $this->className = $className;
        return $this;
    }

    public function setVersion($version)
    {
        $this->version = $version;
        return $this;
    }

    public function setActive($active)
    {
        $this->active = $active;
        return $this;
    }

    public function setOptions($options)
    {
        $this->options = json_encode($options);
        return $this;
    }
}
