<?php

/* * ********************************************************************
 * DiscountCenter product developed. (2015-11-23)
 * *
 *
 *  CREATED BY MODULESGARDEN       ->       http://modulesgarden.com
 *  CONTACT                        ->       contact@modulesgarden.com
 *
 *
 * This software is furnished under a license and may be used and copied
 * only  in  accordance  with  the  terms  of such  license and with the
 * inclusion of the above copyright notice.  This software  or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person.  No title to and  ownership of the  software is  hereby
 * transferred.
 *
 *
 * ******************************************************************** */

namespace MGModule\DomainAndEmailForwarding\models\whmcs;

use MGModule\DomainAndEmailForwarding as main;

/**
 * Description of DomainPrice
 *
 * @author Pawel Kopec <pawelk@modulesgarden.com>
 * @Table(name=tbldomainpricing,preventUpdate,prefixed=false)
 */
class DomainPricing extends main\mgLibs\models\Orm
{
    /**
     * @Column()
     * @var int
     */
    protected $id;

    /**
     * @Column(name=extension)
     * @var string 
     */
    protected $extension;

    /**
     * @Column(name=dnsmanagement,as=dnsManagement)
     * @var string 
     */
    protected $dnsManagement;

    /**
     * @Column(name=emailforwarding,as=emailForwarding)
     * @var string 
     */
    protected $emailForwarding;

    /**
     * @Column(name=idprotection,as=idProtection)
     * @var string 
     */
    protected $idProtection;

    /**
     * @Column(name=eppcode,as=eppCode)
     * @var string 
     */
    protected $eppCode;

    /**
     * @Column(name=autoreg,as=autoreg)
     * @var string 
     */
    protected $autoreg;
    private $domainSetting;

    public function getId()
    {
        return $this->id;
    }

    public function getExtension()
    {
        return $this->extension;
    }

    public function getDnsManagement()
    {
        return $this->dnsManagement;
    }

    public function getEmailForwarding()
    {
        return $this->emailForwarding;
    }

    public function getIdProtection()
    {
        return $this->idProtection;
    }

    public function enabledAddons()
    {
        return $this->idProtection || $this->emailForwarding || $this->dnsManagement;
    }

    public function getEppCode()
    {
        return $this->eppCode;
    }

    public function getAutoreg()
    {
        return $this->autoreg;
    }

    /**
     * 
     * @return  main\models\DomainSetting
     */
    public function domainSetting()
    {

        if (!empty($this->domainSetting))
            return $this->domainSetting;

        $repository = new main\repository\DomainSettingRepository();
        $repository->whereDomainPricingId($this->getId());

        if ((int) $repository->count() > 0)
            return $this->domainSetting = $repository->fetchOne();
        else
            return $this->domainSetting = new main\models\DomainSetting();
    }
}
