<?php

/* * ********************************************************************
 * DomainAndEmailForwarding product developed. (2016-06-29)
 * *
 *
 *  CREATED BY MODULESGARDEN       ->       http://modulesgarden.com
 *  CONTACT                        ->       contact@modulesgarden.com
 *
 *
 * This software is furnished under a license and may be used and copied
 * only  in  accordance  with  the  terms  of such  license and with the
 * inclusion of the above copyright notice.  This software  or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person.  No title to and  ownership of the  software is  hereby
 * transferred.
 *
 *
 * ******************************************************************** */

namespace MGModule\DomainAndEmailForwarding\models;

use MGModule\DomainAndEmailForwarding as main;

/**
 * Description of DomainSetting
 *
 * @author Pawel Kopec <pawelk@modulesgarden.com>
 * @Table(name=domain_settings)
 */
class DomainSetting extends main\mgLibs\models\Orm
{
    /**
     * ID field
     * 
     * @Column(id)
     * @var int 
     */
    protected $id;

    /**
     * @Column(boolean,name=domain_pricing_id,as=domainPricingId)
     * @var boolean
     */
    protected $domainPricingId;

    /**
     * @Column(boolean,name=url_forwarding,as=urlForwarding)
     * @var boolean
     */
    protected $urlForwarding;

    /**
     * @Column(boolean,name=email_forwarding,as=emailForwarding)
     * @var boolean
     */
    protected $emailForwarding;

    /**
     * @Column(boolean,name=subfolders_redirect,as=subfoldersRedirect)
     * @var boolean
     */
    protected $subfoldersRedirect;

    /**
     * @Column(varchar,name=nameserver1)
     * @var string
     */
    protected $nameserver1;

    /**
     * @Column(varchar,name=nameserver2)
     * @var string
     */
    protected $nameserver2;

    /**
     * @Column(varchar,name=nameserver3)
     * @var string
     */
    protected $nameserver3;

    /**
     * @Column(varchar,name=nameserver4)
     * @var string
     */
    protected $nameserver4;

    /**
     * @Column(varchar,name=nameserver5)
     * @var string
     */
    protected $nameserver5;

    /**
     * @Column(int,name=submodule)
     * @var int
     */
    protected $submodule;

    public function getId()
    {
        return $this->id;
    }

    public function getDomainPricingId()
    {
        return $this->domainPricingId;
    }

    public function getNameserver1()
    {
        return $this->nameserver1;
    }

    public function getNameserver2()
    {
        return $this->nameserver2;
    }

    public function getNameserver3()
    {
        return $this->nameserver3;
    }

    public function getNameserver4()
    {
        return $this->nameserver4;
    }

    public function getNameserver5()
    {
        return $this->nameserver5;
    }

    public function getNameservers()
    {
        return array(
            $this->nameserver1,
            $this->nameserver2,
            $this->nameserver3,
            $this->nameserver4,
            $this->nameserver5
        );
    }

    public function getSubmodule()
    {
        return $this->submodule;
    }

    public function isUrlForwarding()
    {
        return $this->urlForwarding == "1";
    }

    public function isEmailForwarding()
    {
        return $this->emailForwarding == "1";
    }

    public function isSubfoldersRedirect()
    {
        return $this->subfoldersRedirect == "1";
    }

    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }

    public function setSubmodule($submodule)
    {
        $this->submodule = $submodule;
        return $this;
    }

    public function setDomainPricingId($domainPricingId)
    {
        $this->domainPricingId = $domainPricingId;
        return $this;
    }

    public function setUrlForwarding($urlForwarding)
    {
        $this->urlForwarding = $urlForwarding;
        return $this;
    }

    public function setEmailForwarding($emailForwarding)
    {
        $this->emailForwarding = $emailForwarding;
        return $this;
    }

    public function setSubfoldersRedirect($subfoldersRedirect)
    {
        $this->subfoldersRedirect = $subfoldersRedirect;
        return $this;
    }

    public function setNameserver1($namesever)
    {
        $this->nameserver1 = $namesever;
        return $this;
    }

    public function setNameserver2($namesever)
    {
        $this->nameserver2 = $namesever;
        return $this;
    }

    public function setNameserver3($namesever)
    {
        $this->nameserver3 = $namesever;
        return $this;
    }

    public function setNameserver4($namesever)
    {
        $this->nameserver4 = $namesever;
        return $this;
    }

    public function setNameserver5($namesever)
    {
        $this->nameserver5 = $namesever;
        return $this;
    }
}
