<?php

/* * ********************************************************************
 * DiscountCenter product developed. (2015-11-16)
 * *
 *
 *  CREATED BY MODULESGARDEN       ->       http://modulesgarden.com
 *  CONTACT                        ->       contact@modulesgarden.com
 *
 *
 * This software is furnished under a license and may be used and copied
 * only  in  accordance  with  the  terms  of such  license and with the
 * inclusion of the above copyright notice.  This software  or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person.  No title to and  ownership of the  software is  hereby
 * transferred.
 *
 *
 * ******************************************************************** */

namespace MGModule\DomainAndEmailForwarding\controllers\addon\admin;

use MGModule\DomainAndEmailForwarding as main;

/**
 * Description of Logs
 *
 * @author Pawel Kopec <pawelk@modulesgarden.com>
 */
class Logs
{

    function indexHTML($input, $vars = array())
    {

        return array(
            'tpl'  => 'logs'
            , 'vars' => $vars
        );
    }

    public function listJSON($input, $vars = array())
    {

        $repository = new main\repository\LogRepository();
        $data       = array();
        foreach ($repository->get() as $log)
        {
            $data[] = $this->_formatLogRow($log);
        }
        return array(
            'data'            => $data
            , 'recordsTotal'    => count($data)
            , 'recordsFiltered' => count($data)
        );
    }

    private function _formatLogRow(main\models\Log $log)
    {

        return array(
            'DT_RowData' => array('id' => $log->getId()),
            $log->getId(),
            '<span class="msg-status' . $log->getStatus() . '">' . $log->getMessage() . '</span>',
            $log->getDate(),
            main\mgLibs\Smarty::I()->view('rowAction', array('id' => $log->getId()))
        );
    }

    public function deleteJSON($input, $vars = array())
    {

        $log = new main\models\Log($input['id']);
        $log->delete();
        return array(
            'deleted' => $this->_formatLogRow($log),
            'success' => sprintf(main\mgLibs\lang::T('Log %s has been deleted'), $log->getId())
        );
    }

    public function deleteAllLogsJSON($input, $vars = array())
    {
        $repository = new main\repository\LogRepository();
        $repository->truncate();
        return array('success' => sprintf(main\mgLibs\lang::T('Logs have been deleted')));
    }
}
