CONTENTS OF THIS FILE
---------------------

 * Introduction
 * Installation
 * License
 * Maintainers


INTRODUCTION
------------

BusyRack cPanel DNS Manager for WHMCS is an addon module which allows
customers who have only domain names without a hosting package to manage
DNS zones of their domain names. It is integrated directly into WHMCS
template under Domains Management area. Once client enters DNS Manager for
a domain name, the module will automatically connect to a cPanel server
and create a zone file. Client will be able to add/edit/delete DNS records
via DNS Manager interface.

Currently, the module supports these DNS record types:

 * `A`     : IPv4 record
 * `AAAA`  : IPv6 record
 * `NS`    : Nameserver record
 * `MX`    : Mail Exchange record
 * `CNAME` : Canonical Name record
 * `SRV`   : Serivce record
 * `TXT`   : Free text record


INSTALLATION
------------

NOTE: You can find modified .tpl files for default WHMCS templates in this github repo:
https://github.com/busyrack/cpanel-dns-manager-templates

1. Unpack the module and place in into WHMCS addons directory. The
directory should look like this: `modules/addons/br_dnsmanager`

2. In your current template directory, edit dropdown-menu in file
`clientareadomains.tpl` to be similar to this:

        ....
        <ul class="dropdown-menu">
           <li><a href="clientarea.php?action=domaindetails&id={$domain.id}#tab3"><i class="icon-globe"></i> {$LANG.domainmanagens}</a></li>
           <li><a href="index.php?m=br_dnsmanager&id={$domain.id}"><i class="icon-globe"></i> Domain DNS Manager</a></li>
           <li><a href="clientarea.php?action=domaincontacts&domainid={$domain.id}"><i class="icon-user"></i> {$LANG.domaincontactinfoedit}</a></li>
           <li><a href="clientarea.php?action=domaindetails&id={$domain.id}#tab2"><i class="icon-globe"></i> {$LANG.domainautorenewstatus}</a></li>
           <li class="divider"></li>
           <li><a href="clientarea.php?action=domaindetails&id={$domain.id}"><i class="icon-pencil"></i> {$LANG.managedomain}</a></li>
        </ul>
        ....

3. *Only needed in WHMCS v5.x*
In your current template directory, edit file
`clientareadomaindetails.tpl` to look like this:

        ... around line number 36,37,38 ...
        {if $registerns}<li><a href="clientarea.php?action=domainregisterns&domainid={$domainid}">{$LANG.domainregisterns}</a></li>{/if}
        {if $dnsmanagement}<li><a href="index.php?m=br_dnsmanager&id={$domainid}">{$LANG.clientareadomainmanagedns}</a></li>{/if}
        {if $emailforwarding}<li><a href="clientarea.php?action=domainemailforwarding&domainid={$domainid}">{$LANG.clientareadomainmanageemailfwds}</a></li>{/if}
        ...................................

    and

        ... around line number 294,295,296,297 ...
        {if $addonstatus.dnsmanagement}
        <a href="index.php?m=br_dnsmanager&id={$domainid}">Manage</a> | <a href="clientarea.php?action=domainaddons&id={$domainid}&disable=dnsmanagement&token={$token}">Disable</a>
        {else}
        <a href="clientarea.php?action=domainaddons&id={$domainid}&buy=dnsmanagement&token={$token}">{$LANG.domainaddonsbuynow} {$addonspricing.dnsmanagement}</a>
        {/if}
        ..........................................

4. Activate the addon in Setup >> Addon Modules

5. Click on Configure and enter a license key

6. Configure cPanel DNS server details in Addons >> Busyrack DNS Manager


LICENSE
-------

This source file is subject to BusyRack Development license that is available
through the world-wide-web at the following URI:

https://www.busyrack.com/license.txt

If you did not receive a copy of the License and are unable to obtain it
through the web, please send a note to license@busyrack.com so we can mail you
a copy immediately.


MAINTAINERS
-----------

Current maintainers:

 * Tom Tran <tom@busyrack.com>

This project is maintained by BusyRack Team.
