<?php



/**

 * WHMCS API Wrapper PHP Library

 *

 * @author      Bankole Olaoluwa

 * @copyright   2016 Bankork

 * @link        olaoluwa.bankole@upperlink.ng

 * @license     MIT LICENSE

 * @version     1.0.0

 * @package     Whmcs

 * 

 */



namespace Whmcs;



class Order extends \Whmcs\Api {



    /**

     * Create a new order

     *

     * Parameters:

     *

     * clientid - client id for order

     * pid - product id

     * domain - domain name

     * billingcycle - onetime, monthly, quarterly, semiannually, etc..

     * addons - comma seperated list of addon ids

     * customfields - a base64 encoded serialized array of custom field values

     * configoptions - a base64 encoded serialized array of configurable product options

     * domaintype - set for domain registration - register or transfer

     * regperiod - 1,2,3,etc...

     * dnsmanagement - true to enable

     * emailforwarding - true to enable

     * idprotection - true to enable

     * eppcode - if transfer

     * nameserver1 - first nameserver (req for domain reg only)

     * nameserver2 - second nameserver

     * nameserver3 - third nameserver

     * nameserver4 - fourth nameserver

     * paymentmethod - paypal, authorize, etc...

     * promocode - pass coupon code to apply to the order (optional)

     * affid - affiliate ID if you want to assign the order to an affiliate (optional)

     * noinvoice - set true to not generate an invoice for this order

     * noemail - set true to surpress the order confirmation email

     * clientip - can be used to pass the customers IP (optional)

     *

     * See:

     *

     * http://docs.whmcs.com/API:Add_Order

     */

    public static function addOrder($params = array()) {

        

        if (isset($params["userId"])) {

            $params["clientid"] = $params["userId"];

        }

        

        $params['action'] = 'addorder';

        return self::sendRequest($params);

    }



    /**

     * Get orders

     * Parameters:

     *

     * limitstart - The record number to start at (default = 0)

     * limitnum - The number of order records to return (default = 25)

     * @see http://docs.whmcs.com/API:Get_Orders

     */

    public static function getOrders($params = array()) {

        $params['action'] = 'getorders';

        return self::sendRequest($params);

    }



    /**

     * Get products

     * pid - can be used to just retrieve the details of a specific product ID

     * gid - can be passed to just retrieve products in a specific group

     * module - can be passed to just retrieve products assigned to a specific module

     * @see http://docs.whmcs.com/API:Get_Products

     */

    public static function getProducts($params = array()) {

        $params['action'] = 'getproducts';

        return self::sendRequest($params);

    }



    /**

     * Get promotions

     *

     * @see http://docs.whmcs.com/API:Get_Promotions

     */

    public static function getPromotions($params = array()) {

        $params['action'] = 'getpromotions';

        return self::sendRequest($params);

    }



    /**

     * Get order statuses

     *

     * @see http://docs.whmcs.com/API:Get_Order_Statuses

     */

    public static function getOrderStatuses() {

        $params['action'] = 'getorderstatuses';

        return self::sendRequest($params);

    }



    /**

     * Accept an order

     * orderid - the Order ID

     * @see http://docs.whmcs.com/API:Accept_Order

     */

    public static function acceptOrder($params = array()) {

        $params['action'] = 'acceptorder';

        return self::sendRequest($params);

    }



    /**

     * Place an order in pending

     *

     * @see http://docs.whmcs.com/API:Pending_Order

     */

    public static function pendingOrder($params = array()) {

        $params['action'] = 'pendingorder';

        return self::sendRequest($params);

    }



    /**

     * Cancel an order

     *

     * @see http://docs.whmcs.com/API:Cancel_Order

     */

    public static function cancelOrder($params = array()) {

        $params['action'] = 'cancelorder';

        return self::sendRequest($params);

    }



    /**

     * Mark an order as fraud

     *

     * @see http://docs.whmcs.com/API:Fraud_Order

     */

    public static function fraudOrder($params = array()) {

        $params['action'] = 'fraudorder';

        return self::sendRequest($params);

    }



    /**

     * Delete an order

     *

     * @see http://docs.whmcs.com/API:Delete_Order

     */

    public static function deleteOrder($params = array()) {

        $params['action'] = 'deleteorder';

        return self::sendRequest($params);

    }



}

