<?php

class Plesk extends Panel {
	
	protected function getBaseUrl() {
		return 'https://'.$this->server->ip.':8443';
	}
	
	protected function callApiOld() {
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $this->getBaseUrl().'/login_up.php3');
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_USERAGENT, $_SERVER['HTTP_USER_AGENT']);
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
		curl_setopt($ch, CURLOPT_COOKIEFILE, $this->tmpFile);
		curl_setopt($ch, CURLOPT_COOKIEJAR, $this->tmpFile);
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_POSTFIELDS, "login_name={$this->username}&passwd={$this->password}&locale_id=default&send=");
		$r = curl_exec($ch);
		if (strpos($r, 'name="login_name"') !== false && strpos($r, 'name="passwd"') !== false) {
			throw new ErrorException('Username or password of Plesk panel user is incorrect');
		}
		
		curl_setopt($ch, CURLOPT_URL, $this->getBaseUrl().'/modules/siteprobuilder/?dom_id='.$this->domain.'&return_url=1');
		$r = curl_exec($ch);
		
		$status = curl_getinfo($ch, CURLINFO_HTTP_CODE);
		if ($status == 404) {
			throw new ErrorException('Site Builder extension is not installed on Plesk panel');
		}
		curl_close($ch);
		return $r;
	}
	
	protected function callApi() {
		$userIp = (isset($_SERVER['REMOTE_ADDR']) && $_SERVER['REMOTE_ADDR']) ? base64_encode($_SERVER['REMOTE_ADDR']) : null;
		$host = $this->server->host ? $this->server->host : null;
		if (!$host) $host = $this->server->ip;
		$serverHost = (isset($_SERVER['HTTP_HOST']) && $_SERVER['HTTP_HOST']) ? base64_encode($_SERVER['HTTP_HOST']) : null;
		$req = <<<REQ
<server>
	<create_session>
		<login>{$this->username}</login>
		<data>
			<user_ip>{$userIp}</user_ip>
			<source_server>{$serverHost}</source_server>
		</data>
	</create_session>
</server>
REQ;
		$resp = XmlRpcApi::getInstance($host, $this->server->username, $this->server->password)->call($req, '1.6.3.5');
		if (isset($resp->server->create_session->result) && ($res = $resp->server->create_session->result)) {
			if (isset($res->status) && (string) $res->status == 'ok') {
				if (isset($res->id) && $res->id) {
					$sessId = (string) $res->id;
					$redirUrl = urlencode("http://$host:8443/modules/siteprobuilder/?domain={$this->domain}");
					$url = "http://$host:8443/enterprise/rsession_init.php?PHPSESSID={$sessId}&PLESKSESSID={$sessId}&success_redirect_url={$redirUrl}";
					header("Location: $url");
					exit();
				} else {
					throw new ErrorException('Failed to retrieve Plesk session ID');
				}
			} else if (isset($res->status) && (string) $res->status == 'error') {
				$errcode = (isset($res->errcode) && intval($res->errcode)) ? intval($res->errcode) : null;
				$errtext = (isset($res->errtext) && (string) $res->errtext) ? (string) $res->errtext : null;
				if ($errcode == 1001) {
					throw new ErrorException("Error: The specified Plesk user \"{$this->username}\" was not found");
				}
				throw new ErrorException('Plesk API Error'.($errcode ? ' ('.$errcode.')' : '').($errtext ? ': '.$errtext : ''));
			}
		} else {
			$status = (isset($res->status) && (string) $res->status) ? (string) $res->status : null;
			$errcode = (isset($resp->errcode) && intval($res->errcode)) ? intval($res->errcode) : null;
			$errtext = (isset($res->errtext) && (string) $res->errtext) ? (string) $res->errtext : null;
			if ($status == 'error' && $errcode) {
				throw new ErrorException('Plesk API System Error ('.$errcode.')'.($errtext ? ': '.$errtext : ''));
			}
			throw new ErrorException('Plesk API &lt;create_session&gt; call failed');
		}
	}
	
}

class XmlRpcApi {
	
	private $host;
	private $port = 8443;
	private $uri = '/enterprise/control/agent.php';
	private $username;
	private $password;
	
	private static $instance;
	
	private function __construct($host, $username, $password) {
		$this->host = $host;
		$this->username = $username;
		$this->password = $password;
	}
	
	public function call($xml, $packetVersion='1.6.5.0') {
		if (strpos('<?xml', $xml) === false) {
			if (strpos('<packet', $xml) === false) {
				$xml = "<packet version=\"$packetVersion\">$xml</packet>";
			}
			$xml = '<?xml version="1.0" encoding="utf-8"?>'.$xml;
		}
		$url = 'https://'.$this->host.':'.$this->port . $this->uri;
		$headers = array(
			'HTTP_AUTH_LOGIN: '.$this->username,
			'HTTP_AUTH_PASSWD: '.$this->password,
			'Content-Type: text/xml'
		);
	
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $xml);
		
		$ret = curl_exec($ch);
		$errno = curl_errno($ch);
		if ($errno) {
			$error = curl_error($ch);
			throw new ErrorException("cURL Error: $error ($errno)");
		}
		curl_close($ch);
		
		try {
			$result = simplexml_load_string($ret);
		} catch (Exception $ex) {
			throw new ErrorException("XML Error: {$ex->getMessage()}");
		}
		return $result;
	}
	
	public static function getInstance($serverIp, $username, $password) {
		if (!self::$instance) {
			self::$instance = new self($serverIp, $username, $password);
		}
		return self::$instance;
	}
	
}