<?php

/* * ********************************************************************
 * DomainAndEmailForwarding product developed. (2016-07-05)
 * *
 *
 *  CREATED BY MODULESGARDEN       ->       http://modulesgarden.com
 *  CONTACT                        ->       contact@modulesgarden.com
 *
 *
 * This software is furnished under a license and may be used and copied
 * only  in  accordance  with  the  terms  of such  license and with the
 * inclusion of the above copyright notice.  This software  or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person.  No title to and  ownership of the  software is  hereby
 * transferred.
 *
 *
 * ******************************************************************** */

namespace MGModule\DomainAndEmailForwarding\controllers\addon\clientarea;
use MGModule\DomainAndEmailForwarding as main;

/**
 * Domain Controler
 *
 * @author Pawel Kopec <pawelk@modulesgarden.com>
 * @version 1.0.0
 */
abstract class DomainControler extends main\mgLibs\process\AbstractController{

    protected $domainId;
    protected $domain;
    protected $submodule;
    
    /**
     * 
     * @return main\models\whmcs\Domain
     * @throws main\mgLibs\exceptions\System
     */
    protected function domain(){
        if(!empty($this->domain))
            return $this->domain;
        $domain = new main\models\whmcs\Domain($this->getDomainId());
        if($domain->getUserId() != $_SESSION['uid'])
            throw new main\mgLibs\exceptions\System("No access to that domain.");
               
        return $this->domain = $domain;
    }
    
    protected function getDomainId() {
        return $this->domainId;
    }
    
    protected function checkSubmodule() {
        $submoduleId = $this->domain()->domainPricing()->domainSetting()->getSubmodule();
        $submodule = new main\models\SubmoduleConfiguration($submoduleId);
        if(!$submodule->isActive()) {
            throw new main\mgLibs\exceptions\System("No access to that domain.");
        }
    }
    
    protected function checkEnabledHosting() {
        $domain = $this->domain();
        if(\WHMCS\Service\Service::where('domain', $domain->getDomain())->count() > 0) {
            $registry = main\models\Registry::getInstance();
            $enabledHosting = $registry->getEnabledHosting();
            if($enabledHosting) {
                throw new main\mgLibs\exceptions\System("This domain has enabled hosting");
            }
        }
    }
    
    protected function dnsZonePolicy() {
        $domain = $this->domain();
        try {
            $zone = main\mgLibs\MySQL\Query::query("SELECT name FROM dns_manager2_zone WHERE name LIKE '{$domain->getDomain()}'")->fetch();

            if(!empty($zone)){
                throw new main\mgLibs\exceptions\System("This domain has enabled DNS Manager zone");
            }
        } catch (main\mgLibs\MySQL\Exception $e) {

        } catch (\Exception $e) {
            throw $e;
        }
    }

    protected function nameserverPolicy() {
        $nameservers = $this->domain()->domainPricing()->domainSetting()->getNameservers();
        $nameservers = array_filter($nameservers);
        if(empty($nameservers)) {
            $registry = main\models\Registry::getInstance();
            $nameservers = $registry->getNameservers();
        }
        $nameservers = array_filter($nameservers);
        if(empty($nameservers)){
            return;
        }
        
        $currentNameservers = main\mgLibs\whmcsAPI\WhmcsAPI::request(
                "domaingetnameservers",
                array('domainid' => $this->getDomainId())
        );
        if($currentNameservers['result'] == 'success') {
            unset($currentNameservers['result']);
            $common = array_intersect($nameservers, $currentNameservers);
            if(count($common) < 2) {
                $nameserversToSet = (array_filter(array_diff($nameservers, $common)));
                return $nameserversToSet;
            }
        }
    }
    
    protected function adjustSidebar(){
        if(!$this->domain()->domainPricing()->enabledAddons()) {
            \Menu::PrimarySidebar()->getChild('manage')->removeChild('addons');
        }
    }
    
    protected function setDomainId($domainId) {
        $this->domainId = $domainId;
        return $this;
    }
    
    /**
     * 
     * @return main\service\IntegrationModule
     */
    protected function submodule(){
        
        if(!empty($this->submodule))
            return $this->submodule;
        
        $manager = new main\service\IntegrationManager();
        return $this->submodule = $manager->getActiveModule($this->domain());
        
    }
    
}
