<?php

class CPanelNew implements IPanel {
	
	public $username;
	public $password;
	public $domain;
	/** @var ServerData */
	public $server;
	
	/** @var SiteproBuilder */
	protected $module;
	
	public function __construct() {
		define('SITEPROBUILDER_WHMCS', true);
		require_once dirname(__FILE__).'/CPanelNew/SiteproBuilder.class.php';
	}
	
	public function identifyUser($username, $password, $domain, $serverData) {
		$this->username = $username;
		$this->password = $password;
		$this->domain = $domain;
		$this->server = new ServerData($serverData);
		if (!$this->server->ip && $this->server->host) {
			$this->server->ip = gethostbyname($this->server->host);
		}
	}
	
	private function handleBuilderOpen($domain) {
		try {
			$this->module->openBuilder($domain, $this->username, $this->password, false);
			exit();
		} catch (ErrorException $ex) {
			return 'Error: '.$ex->getMessage();
		}
	}
	
	public function process() {
		$this->module = new SiteproBuilder(Panel::$apiUrl, Panel::$apiUsername, Panel::$apiPassword);
		$this->module->setServerAddr($this->server->ip);
		$this->module->identifyWHMUser(
				'https://'.$this->server->host.':2087/',
				$this->server->username,
				$this->server->password);
		$this->module->identifyCpanelUser($this->username);
		$api = $this->module->cpanelApi();
		if (isset($_GET['domain']) && $_GET['domain']) {
			$this->handleBuilderOpen($_GET['domain']);
		}
		$list = $api->call('DomainInfo', 'domains_data', array('format' => 'list'));
		if (count($list) == 1) {
			$this->handleBuilderOpen($list[0]['domain']);
		}
		if (($apiLogging = $api->getLogging()) && $apiLogging->isLogEnabled()) exit();
		return $this->genDomainListHtml($list);
	}
	
	private function genDomainListHtml($list) {
		$html = '<p>'.$this->module->langValue('SiteproBuilder_ChooseDomainDesc').'</p>'
				.'<h2>'.$this->module->langValue('SiteproBuilder_SelectDomain').'</h2>'
				.'<table class="table">'
					.'<thead>'
						.'<tr>'
							.'<th>'.$this->module->langValue('SiteproBuilder_Domain').'</th>'
							.'<th>'.$this->module->langValue('SiteproBuilder_DocRoot').'</th>'
						.'</tr>'
					.'</thead>'
					.'<tbody>';
		if (empty($list)) {
			$html .= '<tr><td colspan="2">No domains</td></tr>';
		} else {
			foreach ($list as $li) {
				$html .= '<tr>'
						.'<td><a href="?'.self::getQueryString(array('domain' => $li['domain'])).'">'.$li['domain'].'</a></td>'
						.'<td>'.$li['documentroot'].'</td>'
					.'</tr>';
			}
		}
		$html .= '</tbody></table>';
		return $html;
	}
	
	private static function getQueryString($extraParams = array()) {
		$parts = explode('?', $_SERVER['REQUEST_URI'], 2);
		$qs = (isset($parts[1]) ? $parts[1] : '');
		$params = array(); parse_str(html_entity_decode($qs), $params);
		return http_build_query(array_merge($params, $extraParams));
	}
	
}
