<?php
 
use \ModulesGarden\GSuite\App\PDOWrapper;
 
/**********************************************************************
 *  GSuite Reseller Module for WHMCS (21.11.12)
 *
 *
 *  CREATED BY MODULESGARDEN       ->        http://modulesgarden.com
 *  CONTACT                        ->       contact@modulesgarden.com
 *
 *
 * This software is furnished under a license and may be used and copied
 * only  in  accordance  with  the  terms  of such  license and with the
 * inclusion of the above copyright notice.  This software  or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person.  No title to and  ownership of the  software is  hereby
 * transferred.
 *
 *
 **********************************************************************/
/**
 * @version 1.0.1 (19.03.2013)
 * @author <pawel@modulesgarden.com>
 * 
 * Callback file responsible for redirects during OAuth authentication
 */


/* * ***********************************
 * 
 *          LOAD ENVIRONMENT
 * 
 * *********************************** */

define('DS', DIRECTORY_SEPARATOR);
define('MAIN_WHMCS_DIR', dirname(__FILE__));

/* * ***********************************
 * 
 *  SETTINGS AND CONFIGURATION
 * 
 * *********************************** */

ob_start();

if (file_exists(MAIN_WHMCS_DIR .DS. "init.php"))
{
    require_once MAIN_WHMCS_DIR .DS. "init.php";
}
else
{
    die('Cannot required init.php');
}

$includePath = MAIN_WHMCS_DIR.DS.'modules'.DS.'servers'.DS.'gSuite'.DS. 'vendor' . DS . 'autoload.php';
if(file_exists($includePath))
{
    require_once $includePath;
}
else
{
    echo 'Module Files Incomplete';
    die();
}

function gSuiteSaveWHMCSconfig($key, $value)
{
    $query = PDOWrapper::query("SELECT `value` FROM tblconfiguration WHERE `setting` = ?", array($key));
    $ret = PDOWrapper::fetch_array($query);

    if(isset($ret['value']))
    {
       return PDOWrapper::query("UPDATE tblconfiguration SET value = ? WHERE setting = ?", array($value, $key));
    }

    return PDOWrapper::query("INSERT INTO tblconfiguration  (setting,value) VALUES (?,?)", array($key, $value));
}

function gSuiteGetWHMCSconfig($key)
{
    $query = PDOWrapper::query("SELECT value FROM tblconfiguration WHERE setting = ?", array($key));
    $ret = PDOWrapper::fetch_array($query);
    if($ret['value'])
    {
        return $ret['value'];
    }
}

if(isset($_REQUEST['whmcsproductid']))
{
    gSuiteSaveWHMCSconfig('googleapps_tempproductid', $_REQUEST['whmcsproductid']);
    unset($_REQUEST['whmcsproductid']);
    
    $link="https://accounts.google.com/o/oauth2/auth?".http_build_query($_REQUEST);
    header('Location: '.$link);
    die(); 
}

if(isset($_REQUEST['code']))
{
    $productid = gSuiteGetWHMCSconfig('googleapps_tempproductid');
    gSuiteSaveWHMCSconfig('googleapps_tempproductid','');
    
    $result  = PDOWrapper::query('SELECT `value` FROM tblconfiguration where `setting` = "SystemURL"');
    $result_array = PDOWrapper::fetch_assoc($result);
    
    global $customadminpath;
    
    if(isset($customadminpath))
    {    
        $adminpath = trim($result_array['value'], '/').DIRECTORY_SEPARATOR.$customadminpath;
    }
    else
    {
        $adminpath = trim($result_array['value'], '/').'/admin';        
    }
    
    $location = $adminpath.'/configproducts.php?action=edit&id='.$productid.'&code='.$_REQUEST['code'];
    
    if(ob_get_level() > 0)
    {
        ob_start();
        ob_clean();
    }
    header('Location: '.$location);
    die();
}
