<?php



/**

 * WHMCS API Wrapper PHP Library

 *

 * @author      Bankole Olaoluwa

 * @copyright   2016 Bankork

 * @link        olaoluwa.bankole@upperlink.ng

 * @license     MIT LICENSE

 * @version     1.0.0

 * @package     Whmcs

 * 

 */



namespace Whmcs;



class Invoice extends \Whmcs\Api {



    /**

     * Get invoices

     *

     * @see http://docs.whmcs.com/API:Get_Invoices

     */

    public static function getInvoices($params = array()) {

        $params['action'] = 'GetInvoices';

        return self::sendRequest($params);

    }



    /**

     * Get an invoice

     *

     * @see http://docs.whmcs.com/API:Get_Invoice

     */

    public static function getInvoice($params = array()) {

        $params['action'] = 'GetInvoice';

        return self::sendRequest($params);

    }



    /**

     * Create a new invoice

     *

     * @see http://docs.whmcs.com/API:Create_Invoice

     */

    public static function createInvoice($params = array()) {

        $params['action'] = 'CreateInvoice';

        return self::sendRequest($params);

    }



    /**

     * Update an existing invoice

     *

     * @see http://docs.whmcs.com/API:Update_Invoice

     */

    public static function updateInvoice($params = array()) {

        $params['action'] = 'UpdateInvoice';

        return self::sendRequest($params);

    }



    /**

     * Add an invoice payment

     *

     * @see http://docs.whmcs.com/API:Add_Invoice_Payment

     */

    public static function addInvoicePayment($params = array()) {

        $params['action'] = 'AddInvoicePayment';

        return self::sendRequest($params);

    }



    /**

     * Attempt to capture payment for an invoice

     *

     * @see http://docs.whmcs.com/API:Capture_Payment

     */

    public static function capturePayment($params = array()) {

        $params['action'] = 'CapturePayment';

        return self::sendRequest($params);

    }



    /**

     * Apply credit from a clients credit balance to an invoice

     *

     * @see http://docs.whmcs.com/API:Apply_Credit

     */

    public static function applyCredit($params = array()) {

        $params['action'] = 'ApplyCredit';

        return self::sendRequest($params);

    }



    /**

     * Add a new billable item

     *

     * @see http://docs.whmcs.com/API:Add_Billable_Item

     */

    public static function addBillableItem($params = array()) {

        $params['action'] = 'AddBillableItem';

        return self::sendRequest($params);

    }



    /**

     * Add a credit to client's account

     *

     * @see http://docs.whmcs.com/API:Add_Credit

     */

    public static function addCredit($params = array()) {

        $params['action'] = 'AddCredit';

        return self::sendRequest($params);

    }



    /**

     * Add transaction

     *

     * @see http://docs.whmcs.com/API:Add_Transaction

     */

    public static function addTransaction($params = array()) {

        $params['action'] = 'AddTransaction';

        return self::sendRequest($params);

    }



    /**

     * Get transactions

     *

     * @see http://docs.whmcs.com/API:Get_Transactions

     */

    public static function getTransactions($params = array()) {

        $params['action'] = 'GetTransactions';

        return self::sendRequest($params);

    }



    /**

     * Update transaction

     *

     * @see http://docs.whmcs.com/API:Update_Transaction

     */

    public static function updateTransaction($params = array()) {

        $params['action'] = 'UpdateTransaction';

        return self::sendRequest($params);

    }



    /**

     * Get configured payment methods

     *

     * @see http://docs.whmcs.com/API:Get_Payment_Methods

     */

    public static function getPaymentMethods() {

        return self::sendRequest(array('action' => 'GetPaymentMethods'));

    }



}

