<?php
/**
 * Upperlink WHMCS Wallet Payment Gateway Module 
 *
 * Payment Gateway modules allow you to integrate payment solutions with the
 * WHMCS platform.
 *
 *
 * @copyright Copyright (c) WHMCS Limited 2015
 * @license http://www.whmcs.com/license/ WHMCS Eula
 * @author Bankole Olaoluwa
 * @link olaoluwa.bankole@upperlink.ng
 * 
 */

use Illuminate\Database\Capsule\Manager as Capsule;

if (!defined("WHMCS")) {
    die("This file cannot be accessed directly");
}

/**
 * Define module related meta data.
 *
 * Values returned here are used to determine module related capabilities and
 * settings.
 *
 * @see http://docs.whmcs.com/Gateway_Module_Meta_Data_Parameters
 *
 * @return array
 */
function uplwallet_MetaData()
{
    return array(
        'DisplayName' => 'Upperlink Wallet Payment',
        'APIVersion' => '1.0', // Use API Version 1.1
        'DisableLocalCredtCardInput' => true,
        'TokenisedStorage' => false,
    );
}

/**
 * Define gateway configuration options.
 *
 * The fields you define here determine the configuration options that are
 * presented to administrator users when activating and configuring your
 * payment gateway module for use.
 *
 * Supported field types include:
 * * text
 * * password
 * * yesno
 * * dropdown
 * * radio
 * * textarea
 *
 * Examples of each field type and their possible configuration parameters are
 * provided in the sample function below.
 *
 * @return array
 */
function uplwallet_config()
{
    return array(
        // the friendly display name for a payment gateway should be
        // defined here for backwards compatibility
        'FriendlyName' => array(
            'Type' => 'System',
            'Value' => 'Upperlink Wallet Payment',
        ),
        // a text field type allows for single line text input
        'secretKey' => array(
            'FriendlyName' => 'Secret Key',
            'Type' => 'text',
            'Size' => '25',
            'Default' => '',
            'Description' => 'Enter your secrey key payment page',
        ),
        "instructions" => array(
        "FriendlyName" => "Wallet Instructions",
        "Type" => "textarea",
        "Rows" => "5",
        "Value" => "",
        "Description" => "The instructions you want displaying to customers who choose this payment method - the invoice number will be shown underneath the text entered above",
        ),
        // the yesno field type displays a single checkbox option
        'testMode' => array(
            'FriendlyName' => 'Test Mode',
            'Type' => 'yesno',
            'Description' => 'Tick to enable test mode',
        ),
    );
}

/**
 * Payment link.
 *
 * Required by third party payment gateway modules only.
 *
 * Defines the HTML output displayed on an invoice. Typically consists of an
 * HTML form that will take the user to the payment gateway endpoint.
 *
 * @param array $params Payment Gateway Module Parameters
 *
 * @see http://docs.whmcs.com/Payment_Gateway_Module_Parameters
 *
 * @return string
 */
function uplwallet_link($params)
{
    date_default_timezone_set("UTC");// set the global timezone
    $payment_url =  "https://domains.upperlink.ng/clients/upl-pay-by-wallet.php";//"https://checkout.globalgatewaye4.firstdata.com/payment"; //Upperlink wallet Payment Url
    $redirect_url = $params['systemurl'] . '/modules/gateways/callback/uplwallet.php'; //upl wallet redirect url after payment

    // Gateway Configuration Parameters
    $secretKey = $params['secretKey'];
    $testMode = $params['testMode'];

    /** Log this transaction */
    // Check if the tbltransactions table exists
    if(!Capsule::schema()->hasTable('tbltransactions')) {
       try {
            Capsule::schema()->create(
                'tbltransactions',
                function ($table) {
                    /** @var \Illuminate\Database\Schema\Blueprint $table */
                    $table->increments('id');
                    $table->integer('client_id')->unsigned();
                    $table->string('invoice_id', 50);
                    $table->string('transaction_ref', 50);
                    $table->string('response_code', 10)->nullable();
                    $table->string('response_description', 10)->nullable();
                    $table->string('first_data_response_description')->nullable();
                    $table->decimal('transaction_rate', 10, 5)->unsigned();
                    $table->string('transaction_description')->nullable();
                    $table->string('transaction_currency', 50);
                    $table->decimal('transaction_amount', 20, 5)->unsigned();
                    $table->string('first_data_transaction_tag', 50)->nullable();
                    $table->enum('transaction_status', ['pending', 'paid', 'failed'])->default("pending");
                    $table->string('payment_method', 50);
                    $table->string('whmcs_version', 10);
                    $table->timestamps();
                }
            );
        } catch (\Exception $e) {
            echo "Unable to create transactions table, please contact the administrator: {$e->getMessage()}";
        }
    }
    
    

    // Invoice Parametersssss
    $invoiceId = $params['invoiceid'];
    $description = $params["description"];
    $amount = $params['amount'];
    $currencyCode = $params['currency'];
    $transaction_ref = "WHM" . uplWalletGenerateTransactionNumber();

    srand(time()); // initialize random generator for x_fp_sequence
    $xFpSequence = $transaction_ref;
    $xFpTimestamp = time(); // needs to be in UTC. Make sure webserver produces UTC
    $hmacData = $secretKey . "^" . $xFpSequence . "^" . $xFpTimestamp . "^" . $amount . "^";
    $xFpHash = hash_hmac('SHA1', $hmacData, $secretKey);

    // System Parameters
    $moduleName = $params['paymentmethod'];
    $whmcsVersion = $params['whmcsVersion'];

    //log the transaction in the database 
    try {
       $id = Capsule::table('tbltransactions')->insert([ "client_id" => $params['clientdetails']['userid'],
                                                         "invoice_id" => $invoiceId,
                                                         "transaction_ref" => $transaction_ref,
                                                         "transaction_description" => $description,
                                                         "transaction_currency" => $currencyCode,
                                                         "transaction_amount" => $params['amount'],
                                                         "payment_method" => $moduleName,
                                                         "whmcs_version" => $whmcsVersion,
                                                         "created_at" => date('Y-m-d H:i:s'),
                                                         "updated_at" => date('Y-m-d H:i:s')
                                                      ]);
    }
    catch(\Exception $e) {
        echo "Unable to log transaction details, please try again: {$e->getMessage()}";
    }

    $postfields = array();
    $postfields['x_secret_key'] = $secretKey;
    $postfields['x_show_form'] = "PAYMENT_FORM";
    $postfields['x_fp_sequence'] = $xFpSequence;
    $postfields['x_fp_hash'] = $xFpHash;
    $postfields['x_fp_timestamp'] = $xFpTimestamp;
    $postfields['x_amount'] = $amount;
    //$postfields['x_test_request'] = "FALSE";
    //$postfields['x_relay_response'] = "TRUE";
    //$postfields['x_invoiceid'] = $invoiceId;
    $postfields['x_invoice_num'] = $transaction_ref;
    $postfields['x_description'] = $description;
    //$postfields['x_payment_url'] = $payment_url;
    $postfields['x_redirect_url'] = $redirect_url;
    $postfields['button_code'] = "Pay Now Upperlink";
    $langPayNow = "Pay with Credit Wallet";

    $htmlOutput = '<form method="post" action="' . $payment_url . '">';
    foreach ($postfields as $k => $v) {
        $htmlOutput .= '<input type="hidden" name="' . $k . '" value="' . urlencode($v) . '" />';
    }
    $htmlOutput .= '<input type="submit" value="' . $langPayNow . '" />';
    $htmlOutput .= '</form>';

    return $htmlOutput;
}

/**
 * Generate Transaction
 *
 * @return string
 * @param int $randStringLength
 * 
 */
function uplWalletGenerateTransactionNumber($randStringLength = 12) {
    $timestring = microtime();
    $secondsSinceEpoch=(integer) substr($timestring, strrpos($timestring, " "), 100);
    $microseconds=(double) $timestring;
    $seed = mt_rand(0,1000000000) + 10000000 * $microseconds + $secondsSinceEpoch;
    mt_srand($seed);
    $randstring = "";

    for($i=0; $i < $randStringLength; $i++){
    $randstring .= mt_rand(0, 9);
    }
    
    //return code
    return (string) $randstring;
}
