<?php

namespace MGModule\GGSSLWHMCS\eServices;

use Illuminate\Database\Capsule\Manager as Capsule;

class ConfigurableOptionService {

    public static function createForProduct($productId, $name) {

        if(!is_null(self::getForProduct($productId))) {
            return;
        }
        
        $optionGroup   = [
            'name'        => 'GoGetSSL - ' . $name,
            'description' => 'Auto generated by module - GoGetSSL #' . $productId
        ];
        $optionGroupId = Capsule::table('tblproductconfiggroups')->insertGetId($optionGroup);

        $optionLink = [
            'gid' => $optionGroupId,
            'pid' => $productId
        ];
        Capsule::table('tblproductconfiglinks')->insert($optionLink);

        $option   = [
            'gid'        => $optionGroupId,
            'optionname' => provisioning\ConfigOptions::OPTION_SANS_COUNT . "|Additional SAN's",
            'optiontype' => 4,
            'qtyminimum' => 0,
            'qtymaximum' => 10,
            'order'      => 0,
            'hidden'     => 0,
        ];
        $optionId = Capsule::table('tblproductconfigoptions')->insertGetId($option);

        $optionsSub = [
            'configid'   => $optionId,
            'optionname' => 'SAN',
            'sortorder'  => 0,
            'hidden'     => 0,
        ];
        $optionSubId = Capsule::table('tblproductconfigoptionssub')->insertGetId($optionsSub);

        $optionSubPrice = [
            'type'         => 'configoptions',
            'currency'     => 'xxxx',
            'relid'        => $optionSubId,
            'msetupfee'    => '0.00',
            'qsetupfee'    => '0.00',
            'ssetupfee'    => '0.00',
            'asetupfee'    => '0.00',
            'bsetupfee'    => '0.00',
            'tsetupfee'    => '0.00',
            'monthly'      => '0.00',
            'quarterly'    => '0.00',
            'semiannually' => '0.00',
            'annually'     => '0.00',
            'biennially'   => '0.00',
            'triennially'  => '0.00',
        ];
        
        $productModel = new \MGModule\GGSSLWHMCS\models\productConfiguration\Repository();
        foreach ($productModel->getAllCurrencies() as $currency) {
            $optionSubPrice['currency'] = $currency->id;
            $optionSubId                = Capsule::table('tblpricing')->insertGetId($optionSubPrice);
        }

    }
    
    public static function getForProduct($productId) {
        return Capsule::table('tblproductconfiggroups')
                ->select('tblproductconfigoptions.id')
                ->join('tblproductconfigoptions', 'tblproductconfigoptions.gid', '=', 'tblproductconfiggroups.id')
                ->where('tblproductconfiggroups.description', '=', 'Auto generated by module - GoGetSSL #' . $productId)
                ->where('tblproductconfigoptions.optionname', 'LIKE', 'sans_count%')
                ->first();
    }
}
