<?php

/* * ********************************************************************
 * MGMF product developed. (2016-02-23)
 * *
 *
 *  CREATED BY MODULESGARDEN       ->       http://modulesgarden.com
 *  CONTACT                        ->       contact@modulesgarden.com
 *
 *
 * This software is furnished under a license and may be used and copied
 * only  in  accordance  with  the  terms  of such  license and with the
 * inclusion of the above copyright notice.  This software  or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person.  No title to and  ownership of the  software is  hereby
 * transferred.
 *
 *
 * ******************************************************************** */

namespace MGModule\DomainAndEmailForwarding\controllers\addon\clientarea;

use MGModule\DomainAndEmailForwarding as main;
use MGModule\DomainAndEmailForwarding\models\Log;

/**
 * Description of Product
 *
 * @author Pawel Kopec <pawelk@modulesgarden.com>
 */
class ForwardDomains extends DomainControler
{

    public function isActive()
    {
        if (!isset($_REQUEST['id']))
            return false;
        $this->setDomainId($_REQUEST['id']);
        return $this->domain()->domainPricing()->domainSetting()->isUrlForwarding();
    }

    public function indexHTML($input, $vars = array())
    {
        $this->checkSubmodule();
        $this->checkEnabledHosting();
        $this->dnsZonePolicy();
        $this->adjustSidebar();
        $this->setDomainId($input['id']);
        $vars['nameserversToSet'] = $this->nameserverPolicy();
        $this->domainPolicy();

        $vars['features'] = $this->submodule()->getFeatures();
        $vars['types']    = $this->submodule()->getTypes();

        $vars['domain']            = $this->domain()->toArray(false);
        $vars['directoryRedirect'] = $this->domain()->domainPricing()->domainSetting()->isSubfoldersRedirect();
        return array(
            'tpl'  => 'forwardDomains'
            , 'vars' => $vars
        );
    }

    private function domainPolicy()
    {

        if (!$this->domain()->domainPricing()->domainSetting()->isUrlForwarding())
            throw new main\mgLibs\exceptions\System("No access to 'Domain Redirects' for that domain.");
    }

    public function listJSON($input, $vars = array())
    {

        $this->setDomainId($input['id']);
        $this->domainPolicy();

        $params = array("domain" => $this->domain()->toArray(false));
        $data   = array();
        try
        {
            $values = $this->submodule()->listDomainRedirects($params);
            foreach ($values as $row)
            {
                $data[] = $this->_formatRow($row);
            }
        }
        catch (\Exception $ex)
        {
            Log::error(sprintf("Domain Redirect list failed '%s' - User ID: %s - Domain ID: %s\r\n", $ex->getMessage(), $_SESSION['uid'], $this->domain()->getId()));
            return array("error" => main\mgLibs\Lang::absoluteT("Module error: ") . $ex->getMessage());
        }

        return array(
            'data'            => $data
            , 'recordsTotal'    => count($data)
            , 'recordsFiltered' => count($data)
        );
    }

    private function _formatRow($row)
    {
        return array(
            $row['domain'],
            $row['sourceurl'],
            $row['targeturl'],
            $row['type'],
            $row['matchwww'] ? '<i class="fa fa-check"></i>' : "",
            $row['wildcard'] ? '<i class="fa fa-check"></i>' : "",
            main\mgLibs\Smarty::I()->view("actionRow", array("row" => $row))
        );
    }

    public function createJSON($input, $vars = array())
    {

        $this->setDomainId($input['id']);
        $this->domainPolicy();

        $input['forward']['wildcard'] = (int) $input['forward']['wildcard'];
        $params                       = array("domain"  => $this->domain()->toArray(false),
            "forward" => $input['forward']
        );
        try
        {
            $msg = $this->submodule()->createDomainRedirect($params);
            if (is_string($msg))
                throw new \Exception($msg);
            Log::success(sprintf("Domain Redirect has been created - User ID: %s - Domain ID: %s\r\n", $_SESSION['uid'], $this->domain()->getId()));
            return array("success" => main\mgLibs\Lang::absoluteT('forwarddomains', 'add_dforward_info_text'));
        }
        catch (\Exception $ex)
        {
            Log::error(sprintf("Domain Redirect createing failed '%s' - User ID: %s - Domain ID: %s\r\n", $ex->getMessage(), $_SESSION['uid'], $this->domain()->getId()));
            return array("error" => main\mgLibs\Lang::absoluteT("Module error: ") . $ex->getMessage());
        }
    }

    public function deleteJSON($input, $vars = array())
    {

        $this->setDomainId($input['id']);
        $this->domainPolicy();
        $params = array("domain"  => $this->domain()->toArray(false),
            "forward" => $input['forward']
        );
        try
        {
            $msg = $this->submodule()->deleteDomainRedirect($params);
            if (is_string($msg))
                throw new \Exception($msg);
            Log::success(sprintf("Domain Redirect has been deleted - User ID: %s - Domain ID: %s\r\n", $_SESSION['uid'], $this->domain()->getId()));
            return array("success" => main\mgLibs\Lang::absoluteT('The Domain Forwarder has been deleted successfully'));
        }
        catch (\Exception $ex)
        {
            Log::error(sprintf("Domain Redirect deleting failed '%s' - User ID: %s - Domain ID: %s\r\n", $ex->getMessage(), $_SESSION['uid'], $this->domain()->getId()));
            return array("error" => main\mgLibs\Lang::absoluteT("Module error: ") . $ex->getMessage());
        }
    }
}
