<?php

/* * ********************************************************************
 * DomainAndEmailForwarding product developed. (2016-06-29)
 * *
 *
 *  CREATED BY MODULESGARDEN       ->       http://modulesgarden.com
 *  CONTACT                        ->       contact@modulesgarden.com
 *
 *
 * This software is furnished under a license and may be used and copied
 * only  in  accordance  with  the  terms  of such  license and with the
 * inclusion of the above copyright notice.  This software  or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person.  No title to and  ownership of the  software is  hereby
 * transferred.
 *
 *
 * ******************************************************************** */

namespace MGModule\DomainAndEmailForwarding\controllers\addon\admin;

use MGModule\DomainAndEmailForwarding as main;

/**
 * Description of Config
 *
 * @author Pawel Kopec <pawelk@modulesgarden.com>
 */
class Settings extends main\mgLibs\process\AbstractController
{

    public function indexHTML($input, $vars = array())
    {

        $form     = new main\mgLibs\forms\Creator('configuration');
        $registry = main\models\Registry::getInstance();

        $form->addField('text', 'general[nameserver1]', array(
            'value'             => $registry->getNameserver1(),
            'id'                => 'mg-general-nameserver1',
            'enablePlaceholder' => true,
        ));
        $form->addField('text', 'general[nameserver2]', array(
            'value'             => $registry->getNameserver2(),
            'id'                => 'mg-general-nameserver2',
            'enablePlaceholder' => true,
        ));
        $form->addField('text', 'general[nameserver3]', array(
            'value'             => $registry->getNameserver3(),
            'id'                => 'mg-general-nameserver3',
            'enablePlaceholder' => true,
        ));
        $form->addField('text', 'general[nameserver4]', array(
            'value'             => $registry->getNameserver4(),
            'id'                => 'mg-general-nameserver4',
            'enablePlaceholder' => true,
        ));
        $form->addField('text', 'general[nameserver5]', array(
            'value'             => $registry->getNameserver5(),
            'id'                => 'mg-general-nameserver5',
            'enablePlaceholder' => true,
        ));

        if (array_filter($registry->getNameservers()))
        {
            $vars['showDomains'] = 1;
        }

        $vars['formGeneral'] = $form->getHTML('modal');
        $form->deleteFields();

        //Domains
        $form->addField('tabStart', '', array('tab' => true, 'id' => 'mg-general-tab', 'value' => 'active'));
        $form->addField('checkbox', 'domains[urlForwarding]', array(
            'options'       => array('urlForwarding', 'subfoldersRedirect'),
            'value'         => array(),
            'default'       => 0,
            'labelcolWidth' => 4,
            'colWidth'      => 8,
            'id'            => 'mg-domains-urlForwarding'
        ));

        $form->addField('checkbox', 'domains[emailForwarding]', array(
            'options'       => array('on'),
            'value'         => array(),
            'default'       => 0,
            'labelcolWidth' => 4,
            'colWidth'      => 8,
            'id'            => 'mg-domains-emailForwarding'
        ));
        $manager = new main\service\IntegrationManager();
        $form->addField('select', 'domains[submodule]', array(
            'options'          => $manager->getAssocModules(),
            'required'         => false,
            'id'               => 'mg-domains-submodule',
            'labelcolWidth'    => 4,
            'colWidth'         => 8,
            'select2'          => true,
            'translateOptions' => false,
            'multiple'         => false,
            'value'            => array(),
        ));

        $form->addField('tabEnd', array('tab' => true));

        $form->addField('tabStart', '', array('tab' => true, 'id' => 'mg-nameservers-tab'));
        $form->addField('text', 'domains[nameserver1]', array(
            'id'                => 'mg-domains-nameserver1',
            'labelcolWidth'     => 3,
            'colWidth'          => 8,
            'enablePlaceholder' => true,
        ));
        $form->addField('text', 'domains[nameserver2]', array(
            'id'                => 'mg-domains-nameserver2',
            'labelcolWidth'     => 3,
            'colWidth'          => 8,
            'enablePlaceholder' => true,
        ));
        $form->addField('text', 'domains[nameserver3]', array(
            'id'                => 'mg-domains-nameserver3',
            'labelcolWidth'     => 3,
            'colWidth'          => 8,
            'enablePlaceholder' => true,
        ));
        $form->addField('text', 'domains[nameserver4]', array(
            'id'                => 'mg-domains-nameserver4',
            'labelcolWidth'     => 3,
            'colWidth'          => 8,
            'enablePlaceholder' => true,
        ));
        $form->addField('text', 'domains[nameserver5]', array(
            'id'                => 'mg-domains-nameserver5',
            'labelcolWidth'     => 3,
            'colWidth'          => 8,
            'enablePlaceholder' => true,
        ));
        $form->addField('tabEnd', array('tab' => true));

        $vars['formDomainEdit']     = $form->getHTML('modal');
        $form->rebuildFieldIds('-mass');
        $vars['formDomainEditMass'] = $form->getHTML('modal');
        $form->deleteFields();

        $enable = ($registry->getEnabledHosting() == 1);
        $form->addField('checkbox', 'domains[enableHosting]', array(
            'options'       => array($enable => main\mgLibs\Lang::T('enableHosting')),
            'value'         => array(1),
            'default'       => 0,
            'labelcolWidth' => 3,
            'colWidth'      => 9,
            'id'            => 'mg-settings-enable-hosting',
        ));

        $vars['formSettings'] = $form->getHTML('modal');
        $form->deleteFields();

        return array(
            'tpl'  => 'settings'
            , 'vars' => $vars
        );
    }

    public function generalHTML($input, $vars = array())
    {
        return $this->indexHTML($input);
    }

    public function saveJSON($input, $vars = array())
    {

        $settings = array(
            "nameserver1" => $input['general']['nameserver1'],
            "nameserver2" => $input['general']['nameserver2'],
            "nameserver3" => $input['general']['nameserver3'],
            "nameserver4" => $input['general']['nameserver4'],
            "nameserver5" => $input['general']['nameserver5'],
        );

        main\models\Registry::getInstance()->save($settings);

        return array(
            'success' => main\mgLibs\lang::T('messages', 'Default Settings have been saved')
        );
    }

    public function saveSettingsJSON($input, $vars = array())
    {

        $settings = array(
            "enable_hosting" => isset($input['domains']['enableHosting'])
        );

        main\models\Registry::getInstance()->save($settings);

        return array(
            'success' => main\mgLibs\lang::T('messages', 'Default Settings have been saved')
        );
    }

    public function domainSettingListJSON($input, $vars = array())
    {

        $repository = new main\repository\whmcs\DomainPricingRepository();
        $data       = array();
        foreach ($repository->fetch() as $entity)
        {
            $data[] = $this->_formatDomainSettingRow($entity);
        }
        return array(
            'data'            => $data
            , 'recordsTotal'    => count($data)
            , 'recordsFiltered' => count($data)
        );
    }

    private function _formatDomainSettingRow(main\models\whmcs\DomainPricing $entity)
    {

        return array(
            'DT_RowData' => array('id' => $entity->getId()),
            '<input class="checkThis" type="checkbox" name="domainsSelected[]" value="' . $entity->getId() . '" />',
            $entity->getExtension(),
            $entity->domainSetting()->isUrlForwarding() ? '<span><i class="glyphicon glyphicon-ok"></i></span>' : '<span><i class="glyphicon glyphicon-remove"></i></span>',
            $entity->domainSetting()->isSubfoldersRedirect() ? '<span><i class="glyphicon glyphicon-ok"></i></span>' : '<span><i class="glyphicon glyphicon-remove"></i></span>',
            $entity->domainSetting()->isEmailForwarding() ? '<span><i class="glyphicon glyphicon-ok"></i></span>' : '<span><i class="glyphicon glyphicon-remove"></i></span>',
            main\mgLibs\Smarty::I()->view('actionDomainRow', array("entity" => $entity->toArray(false)))
        );
    }

    public function domainDetailJSON($input, $vars = array())
    {

        $entity    = new main\models\whmcs\DomainPricing($input['id']);
        $submodule = $entity->domainSetting()->getSubmodule();
        if (!$submodule)
        {
            $manager   = new main\service\IntegrationManager();
            $submodule = key($manager->getAssocModules());
        }
        $options      = array();
        if ($entity->domainSetting()->isUrlForwarding())
            $options[]    = "urlForwarding";
        if ($entity->domainSetting()->isSubfoldersRedirect())
            $options[]    = "subfoldersRedirect";
        $vars['form'] = array(
            'domains[urlForwarding][]'   => $options,
            'domains[emailForwarding][]' => (int) $entity->domainSetting()->isEmailForwarding(),
            'domains[nameserver1]'       => $entity->domainSetting()->getNameserver1(),
            'domains[nameserver2]'       => $entity->domainSetting()->getNameserver2(),
            'domains[nameserver3]'       => $entity->domainSetting()->getNameserver3(),
            'domains[nameserver4]'       => $entity->domainSetting()->getNameserver4(),
            'domains[nameserver5]'       => $entity->domainSetting()->getNameserver5(),
            'domains[submodule]'         => $submodule,
        );
        $vars['vars'] = array(
            "id"  => $entity->getId(),
            "tld" => $entity->getExtension()
        );
        return $vars;
    }

    public function domainDetailsJSON($input, $vars = array())
    {

        $repository = new main\repository\whmcs\DomainPricingRepository();
        $repository->idIn($input['domainsSelected']);

        $tlds = array();
        foreach ($repository->fetch() as $entity)
        {
            $tlds[] = $entity->getExtension();
        }
        $vars['tlds'] = implode(", ", $tlds);

        return $vars;
    }

    public function domainSaveJSON($input, $vars = array())
    {
        $registry    = main\models\Registry::getInstance();
        $nameservers = array(
            $input['domains']['nameserver1'],
            $input['domains']['nameserver2'],
            $input['domains']['nameserver3'],
            $input['domains']['nameserver4'],
            $input['domains']['nameserver5'],
        );

        if (!array_filter($registry->getNameservers()) && !array_filter($nameservers))
        {
            return array(
                'modalError' => main\mgLibs\lang::T('messages', 'Missing nameservers configuration')
            );
        }

//        $submodule = new main\models\SubmoduleConfiguration($input['domains']['submodule']);
//        if(!$submodule->isActive()) {
//            return array(
//                'modalError' => main\mgLibs\lang::T('messages', 'Selected Submodule is not active')
//            );
//        }

        $entity = new main\models\whmcs\DomainPricing($input['id']);
        $entity->domainSetting()->setDomainPricingId($entity->getId())
                ->setEmailForwarding((int) in_array("on", (array) $input['domains']['emailForwarding']))
                ->setUrlForwarding((int) in_array("urlForwarding", (array) $input['domains']['urlForwarding']))
                ->setSubfoldersRedirect((int) in_array("subfoldersRedirect", (array) $input['domains']['urlForwarding']))
                ->setNameserver1($input['domains']['nameserver1'])
                ->setNameserver2($input['domains']['nameserver2'])
                ->setNameserver3($input['domains']['nameserver3'])
                ->setNameserver4($input['domains']['nameserver4'])
                ->setNameserver5($input['domains']['nameserver5'])
                ->setSubmodule($input['domains']['submodule'])
                ->save();

        $vars['success'] = sprintf(main\mgLibs\lang::T('messages', 'Domain \'%s\' setting has been saved'), $entity->getExtension());
        $vars['mgevent'] = 'saved';
        return $vars;
    }

    public function domainsSaveJSON($input, $vars = array())
    {
        foreach ($input['domainsSelected'] as $id)
        {
            $input['id'] = $id;
            $result      = $this->domainSaveJSON($input);
            if ($result['modalError'])
            {
                return $result;
            }
        }
        $vars['success'] = main\mgLibs\lang::T('messages', 'Selected Domains have been saved');
        return $vars;
    }

    public function modulesHTML($input, $vars = array())
    {

        return array(
            'tpl'  => 'modules'
            , 'vars' => $vars
        );
    }

    public function modulesListJSON($input, $vars = array())
    {

        $integrator = new main\service\IntegrationManager();
        $data       = array();
        foreach ($integrator->getModules() as $entity)
        {
            $data[] = $this->_formatModuleRow($entity);
        }
        return array(
            'data'            => $data
            , 'recordsTotal'    => count($data)
            , 'recordsFiltered' => count($data)
        );
    }

    private function _formatModuleRow(main\service\IntegrationModule $entity)
    {

        $integrator = new main\service\IntegrationManager();
        $submodule  = $integrator->getSubmoduleConfiguration($entity->getClassName());

        return array(
            $entity->getName(),
            $entity->getVersion(),
            $entity->getDescription(),
            main\mgLibs\Smarty::I()->view('actionModuleRow', array("entity" => $entity->toArray(), "submodule" => $submodule->toArray(false)))
        );
    }

    public function moduleDetailJSON($input, $vars = array())
    {

        $integrator   = new main\service\IntegrationManager();
        $entity       = $integrator->getModule($input['id']);
        $vars['vars'] = array(
            "name" => $entity->getName(),
        );

        return $vars;
    }

    public function moduleActivateJSON($input, $vars = array())
    {

        $integrator = new main\service\IntegrationManager();
        $entity     = $integrator->getModule($input['id']);

        try
        {
            $msg = $entity->activate();
            if (is_string($msg))
                return array("modalError" => main\mgLibs\Lang::absoluteT("Module error: ") . $msg);

            $integrator->activate($entity);
            $vars['success'] = sprintf(main\mgLibs\lang::T('messages', 'Module \'%s\' has been activated'), $entity->getName());
            $vars['mgevent'] = 'activated';
            return $vars;
        }
        catch (\Exception $ex)
        {
            return array("modalError" => main\mgLibs\Lang::absoluteT("Module error: ") . $ex->getMessage());
        }
    }

    public function moduleDeactivateJSON($input, $vars = array())
    {

        $integrator = new main\service\IntegrationManager();
        $entity     = $integrator->getModule($input['id']);

        try
        {
            $msg = $entity->deactivate();
            if (is_string($msg))
                return array("modalError" => main\mgLibs\Lang::absoluteT("Module error: ") . $msg);

            $integrator->deactivate($entity);
            $vars['success'] = sprintf(main\mgLibs\lang::T('messages', 'Module \'%s\' has been deactivated'), $entity->getName());
            $vars['mgevent'] = 'deactivated';
            return $vars;
        }
        catch (\Exception $ex)
        {
            return array("modalError" => main\mgLibs\Lang::absoluteT("Module error: ") . $ex->getMessage());
        }
    }

    public function moduleConfigurationDetailJSON($input, $vars = array())
    {

        $integrator = new main\service\IntegrationManager();
        $module     = $integrator->getModule($input['id']);

        $form = new main\mgLibs\forms\Creator('configuration');
        foreach ($module->getOptions() as $fieldName => $option)
        {

            $option['value']             = $module->getOptionValue($fieldName);
            $option['id']                = "mg-submodule-field-" . $fieldName;
            $option['enableDescription'] = !empty($option['description']);
            $newOption                   = array(
                "id"                => "mg-submodule-field-" . $fieldName,
                "enableDescription" => !empty($option['description']),
            );
            if ($option['type'] == "password")
                $newOption['showPassword']   = true;

            $form->addField($option['type'], "submodule[{$fieldName}]", array_merge($newOption, $option));
        }
        $out         = array();
        $out['vars'] = array(
            "name" => $module->getName(),
            "html" => $form->getHTML('modal')
        );
        return $out;
    }

    public function moduleTestConnectionJSON($input, $vars = array())
    {

        $integrator = new main\service\IntegrationManager();
        $entity     = $integrator->getModule($input['id']);
        //inject module configuration
        try
        {
            $msg = $entity->testConnection((array) $input['submodule']);
            if (is_string($msg))
                return array("modalError" => main\mgLibs\Lang::absoluteT("Module error: ") . $msg);
            return array("modalSuccess" => main\mgLibs\Lang::T("Successful!"));
        }
        catch (\Exception $ex)
        {
            return array("modalError" => main\mgLibs\Lang::absoluteT("Module error: ") . $ex->getMessage());
        }
    }

    public function moduleSaveJSON($input, $vars = array())
    {

        $integrator = new main\service\IntegrationManager();
        $module     = $integrator->getModule($input['id']);
        $options    = array();
        foreach ($module->getOptions() as $fieldName => $option)
        {
            $options[$fieldName] = (string) $input['submodule'][$fieldName];
            if ($option['type'] == "password")
            {
                $options[$fieldName] = encrypt($options[$fieldName]);
            }
            if ($option['type'] == "checkbox")
            {
                $options[$fieldName] = $input['submodule'][$fieldName];
            }
        }

        $submoduleConfiguration = $integrator->getSubmoduleConfiguration($input['id']);
        $submoduleConfiguration->setOptions($options)
                ->save();
        return array("modalSuccess" => main\mgLibs\Lang::T("Configuration has been saved."));
    }
}
