{**********************************************************************
* MGMF product developed. (2016-02-09)
* *
*
*  CREATED BY MODULESGARDEN       ->       http://modulesgarden.com
*  CONTACT                        ->       contact@modulesgarden.com
*
*
* This software is furnished under a license and may be used and copied
* only  in  accordance  with  the  terms  of such  license and with the
* inclusion of the above copyright notice.  This software  or any other
* copies thereof may not be provided or otherwise made available to any
* other person.  No title to and  ownership of the  software is  hereby
* transferred.
*
*
**********************************************************************}

{**
* @author Paweł Kopeć <pawelk@modulesgarden.com>
*}

<div class="module-main-header">
    <h3>{$MGLANG->T('Domain')} -  {$domain.domain}</h3>
</div>
<div class="module-header">
    <i class="icon-header icon-forwarddomains"></i>
    <h1>{$MGLANG->T('Domain Redirects')}</h1>
    <p>{$MGLANG->T('description')}</p>
</div>

<div class="module-body" id="mg-forwards-content">
    <div class="section">
        {if $nameserversToSet}
            <div class="alert alert-danger">
            <strong>{$MGLANG->absoluteT('forwarddomains', 'wrong_nameservers')}</strong>
            <ul style="margin-left: 20px;">
                {foreach $nameserversToSet as $nameserver}
                    <li>{$nameserver}</li>
                {/foreach}
            </ul>
        </div>
        {else}
            <div style="display: inline-flex;"><h4>{$MGLANG->T('Add New Forwarder')}</h4>
                <button class="show-sm btn btn-icon show-hint" data-toggle="tooltip" title="{$MGLANG->absoluteT('forwarddomains', 'main_hint')} {$lang.main_hint}" type="button"> 
                    <i class="glyphicon glyphicon-question-sign"></i> 
                </button>
            </div>
            <div class="well">
                <form class="form-horizontal" id="domain-forward-form">
                    <input type="hidden" name="id" value="{$domain.id}">
                    {if $features['domainForward']['type']}
                        <div class="form-group">
                            <label class="control-label col-sm-3">{$MGLANG->absoluteT('forwarddomains', 'lbl_type')}</label>
                            <div class="col-sm-9">
                                <div class="row">
                                    <div class="col-sm-6">
                                        <select name="forward[type]" class="form-control">
                                            {foreach $types as $key => $type}
                                                <option value="{$key}">{$MGLANG->absoluteT('forwarddomains', {$type})}</option>
                                            {/foreach}
                                        </select>
                                    </div>
                                    <div class="col-sm-6">

                                    </div>
                                </div>
                            </div>
                        </div>
                    {/if}
                    <div class="form-group">
                        <label class="control-label col-sm-3">http://<div style="float:right" id="rdwww">www.</div></label>
                        {if $directoryRedirect}
                            <div class="input-group col-sm-9">
                                <input class="form-control first" type="text" name="forward[domain]" data-no-validate value="{$domain.domain}"  readonly="">

                                <span class="input-group-addon">/</span>
                                <input class="form-control last" type="text" name="forward[src]" pattern="[^\s]*" data-error="{$validator_lang.invalid}" >
                            </div>
                        {else}
                            <div class="col-sm-9">
                                <div class="row">
                                    <div class="col-sm-6">
                                        <input class="form-control" type="text" name="forward[domain]" data-no-validate value="{$domain.domain}"  readonly="">
                                    </div>
                                    <div class="col-sm-6">

                                    </div>
                                </div>
                            </div>
                        {/if}
                        <div class="col-md-9 col-md-offset-3">
                            <div class="help-block with-errors"></div>
                        </div>  
                    </div>
                    <div class="form-group">
                        <label class="control-label col-sm-3">{$MGLANG->absoluteT('forwarddomains', 'lbl_redirects_to')}</label>
                        <div class="col-sm-9">
                            <div class="row">
                                <div class="col-sm-6">
                                    <input class="form-control" type="text" name="forward[url]" required="" pattern="[^\s]*"  data-error="{$validator_lang.field_required}">
                                </div>
                                <div class="col-sm-6">

                                </div>
                            </div>
                        </div>
                        <div class="col-md-9 col-md-offset-3">
                            <div class="help-block with-errors"></div>
                        </div>   
                    </div>
                    {if $features['domainForward']['rdwww']}
                        <div class="form-group">
                            <label class="control-label col-sm-3">{$MGLANG->absoluteT('forwarddomains', 'lbl_wwwredirection')}</label>
                            <div class="col-sm-9">
                                <div class="row">
                                    <div class="col-sm-6">
                                        <select name="forward[rdwww]" class="form-control">
                                            <option value="2" data-copy="www.">{$MGLANG->absoluteT('forwarddomains', 'lbl_only_www')}</option>
                                            <option value="0" data-copy="(www.)?">{$MGLANG->absoluteT('forwarddomains', 'lbl_without_www')}</option>
                                            <option value="1" data-copy="">{$MGLANG->absoluteT('forwarddomains', 'lbl_not_www')}</option>
                                        </select>
                                    </div>
                                    <div class="col-sm-6">

                                    </div>
                                </div>
                            </div>
                        </div>
                    {/if}
                    {if $features['domainForward']['wildcard']}
                        <div class="form-group">
                            <label class="control-label col-sm-3">{$MGLANG->absoluteT('forwarddomains', 'lbl_wildcard')}</label>
                            <div class="col-sm-9">
                                <div class="row">
                                    <div class="col-sm-6">
                                        <div class="checkbox">
                                            <label><input type="checkbox" name="forward[wildcard]" value="1">&nbsp;</label>
                                        </div>
                                    </div>
                                    <div class="col-sm-6">

                                    </div>
                                </div>
                            </div>
                        </div>
                    {/if}
                    <div class="form-actions">
                        <button type="submit" class="btn btn-inverse btn-success"><i class="fa fa-plus"></i>&nbsp;{$MGLANG->absoluteT('forwarddomains', 'add_domain_forward')}</button>
                    </div>
                </form>
            </div>
        </div>
        <div class="section">
            <div class="table-header">
                <div class="header-title">
                    <h4>{$MGLANG->absoluteT('forwarddomains', 'search_dforward_header')}</h4>
                </div>
                <div class="header-actions">
                    <div class="header-search">
                        <div class="input-icon">
                            <i class="fa fa-search"></i>
                            <input class="form-control" id="mg-input-datatable-search" type="text" placeholder="{$MGLANG->absoluteT('forwarddomains', 'search_placeholder')}">
                        </div>
                    </div>
                </div>
            </div>
            <table class="table" id="domain-forwarders-table">
                <thead>
                    <tr>
                        <th>{$MGLANG->absoluteT('forwarddomains', 'modify_dforward_tblhead_address')}{$lang.modify_dforward_tblhead_address}</th>
                        <th>{$MGLANG->absoluteT('forwarddomains', 'modify_dforward_tblhead_directory')}{$lang.modify_dforward_tblhead_directory}</th>
                        <th>{$MGLANG->absoluteT('forwarddomains', 'modify_dforward_tblhead_forward')}{$lang.modify_dforward_tblhead_forward}</th>
                        <th>{$MGLANG->absoluteT('forwarddomains', 'modify_dforward_tblhead_type')}{$lang.modify_dforward_tblhead_type}</th>
                        <th class="text-center-sm">{$MGLANG->absoluteT('forwarddomains', 'modify_dforward_tblhead_matchwww')}{$lang.modify_dforward_tblhead_matchwww}</th>
                        <th class="text-center-sm">{$MGLANG->absoluteT('forwarddomains', 'modify_dforward_tblhead_wildcard')}{$lang.modify_dforward_tblhead_wildcard}</th>
                        <th>{$MGLANG->absoluteT('forward', 'modify_forward_tblhead_actions')}{$lang.modify_forward_tblhead_actions}</th>
                    </tr>
                </thead>
                <tbody>
                </tbody>
            </table>
        </div>
    {/if}
    {*Modal mg-modal-forward-delete *}
    <form id="mg-form-forward-delete">
        <div class="modal fade bs-example-modal-lg" id="mg-modal-forward-delete"  tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
                        <h4 class="modal-title">{$MGLANG->T('Delete Confirmation')} <strong data-modal-var="tlds"></strong></h4>
                    </div>

                    <div class="modal-body">
                        <input type="hidden" name="id"  value="{$domain.id}">
                        <input type="hidden" name="forward[docroot]" id="mg-modal-forward-delete-docroot"  value="">
                        <input type="hidden" name="forward[sourceurl]"  id="mg-modal-forward-delete-sourceurl"  value="">

                        <div class="modal-alerts">
                            <div style="display:none;" data-prototype="error">
                                <div class="note note-danger">
                                    <button type="button" class="close" data-dismiss="alert"><span aria-hidden="true">&times;</span><span class="sr-only"></span></button>
                                    <strong></strong>
                                    <a style="display:none;" class="errorID" href=""></a>
                                </div>
                            </div>
                            <div style="display:none;" data-prototype="success">
                                <div class="note note-success">
                                    <button type="button" class="close" data-dismiss="alert"><span aria-hidden="true">&times;</span><span class="sr-only"></span></button>
                                    <strong></strong>
                                </div>
                            </div>
                        </div>
                        <div style="margin: 30px; text-align: center;">

                            <div>{$MGLANG->T('Are you sure that you want to remove this redirection?')} </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-inverse btn-default" data-dismiss="modal">{$MGLANG->T('modal','close')}</button>
                        <button type="button" class="btn btn-inverse btn-danger" id="mg-modal-button-delete">{$MGLANG->T('modal','confirm')}</button>
                    </div>
                </div>
            </div>
        </div>
    </form>  
</div>

{literal}
    <script>

        (function (jQuery) {
            jQuery('[name="forward[rdwww]"]').change(function () {
                jQuery('#rdwww').html(jQuery('option:selected', this).data('copy'));
            });
        })(jQuery);

        jQuery(document).ready(function () {
            var mgDataTable;

            mgDataTable = $('#domain-forwarders-table').dataTable({
                processing: false,
                searching: true,
                autoWidth: false,
                "serverSide": false,
                "order": [[0, "desc"]],
                ajax: function (data, callback, settings) {

                    JSONParser.request(
                            'list'
                            , {
                                id: "{/literal}{$domain.id}{literal}"
                                , limit: data.length
                                , offset: data.start
                                , order: data.order
                                , search: data.search
                            }
                    , function (data) {
                        callback(data);
                    }
                    );
                },
                'columns': [
                    null,
                    null,
                    null,
                    null,
                    null,
                    null,
                    {orderable: false}

                ],
                'aoColumnDefs': [{
                        'bSortable': false,
                        'aTargets': ['nosort']
                    }, {"sClass": "center", "aTargets": [4, 5, 6]}],
                language: {
                    "lengthMenu": "{/literal}{$MGLANG->absoluteT('Show _MENU_ entries')}{literal}",
                    "info": "{/literal}{$MGLANG->absoluteT('Showing _START_ to _END_ of _TOTAL_ entries')}{literal}",
                    "zeroRecords": "{/literal}{$MGLANG->absoluteT('Nothing to display')}{literal}",
                    "infoEmpty": "",
                    "search": "{/literal}{$MGLANG->absoluteT('Search')}{literal}",
                    "paginate": {
                        "previous": "{/literal}{$MGLANG->absoluteT('Previous')}{literal}"
                        , "next": "{/literal}{$MGLANG->absoluteT('Next')}{literal}"
                    }
                }
            });

            //Add Domain Forwarder
            $("#domain-forward-form").submit(function (e) {
                e.preventDefault();
                JSONParser.request(
                        'create'
                        , $("#domain-forward-form").serialize()
                        , function (data) {
                            if (!data.error) {
                                mgDataTable.api().ajax.reload();
                            }
                        }
                );
            });

            //Delete 
            $('#mg-forwards-content').on('click', ".mg-delete", function (e) {
                e.preventDefault();
                var modalId = "#" + $(this).attr('data-modal-id');
                $("#mg-modal-forward-delete-docroot").val($(this).attr('data-docroot'));
                $("#mg-modal-forward-delete-sourceurl").val($(this).attr('data-sourceurl'));
                $(modalId).modal();
            });

            $("#mg-modal-button-delete").click(function (e) {
                e.preventDefault();
                JSONParser.request(
                        'delete'
                        , $("#mg-form-forward-delete").serialize()
                        , function (data) {
                            $("#mg-modal-forward-delete").modal('hide');
                            mgDataTable.api().ajax.reload();
                        }
                );
            });

            //Search
            $("#domain-forwarders-table_filter").hide();
            $('#mg-input-datatable-search').on('keyup', function () {
                mgDataTable.api().search(this.value).draw();
            });

        });
    </script>
{/literal}