{**********************************************************************
* DomainAndEmailForwarding product developed. (2016-06-29)
* *
*
*  CREATED BY MODULESGARDEN       ->       http://modulesgarden.com
*  CONTACT                        ->       contact@modulesgarden.com
*
*
* This software is furnished under a license and may be used and copied
* only  in  accordance  with  the  terms  of such  license and with the
* inclusion of the above copyright notice.  This software  or any other
* copies thereof may not be provided or otherwise made available to any
* other person.  No title to and  ownership of the  software is  hereby
* transferred.
*
*
**********************************************************************}

{**
* @author Paweł Kopeć <pawelk@modulesgarden.com>
*}
<div class="box light">
    <div class="row">
        <div class="col-lg-12" id="mg-setting-content" >
            <legend>{$MGLANG->T('General')}</legend>
            <div>
                <!-- Nav tabs -->
                <ul class="nav nav-tabs" role="tablist">
                    <li role="presentation" class=""><a href="#mg-settings" aria-controls="mg-settings" role="tab" data-toggle="tab">
                            {$MGLANG->T('General')}</a>
                    </li>
                    <li role="presentation" class="{if $showDomains}active{/if}"><a href="#mg-domains" aria-controls="mg-domains" role="tab" data-toggle="tab">
                            {$MGLANG->T('Domains')}</a>
                    </li>
                    <li role="presentation" class="{if $showDomains != 1}active{/if}"><a href="#mg-general" aria-controls="mg-general" role="tab" data-toggle="tab">
                            {$MGLANG->T('Nameservers')}</a>
                    </li>
                </ul>
                <!-- Tab panes -->
                <div class="tab-content">
                    <div role="tabpanel" class="tab-pane" id="mg-settings">
                        <form action="" method="post" id="mg-settings-main-form" style="min-height:300px;width:50%" data-toggle="validator" role="form">
                            {$formSettings}
                        </form> 
                        <div class="well well-sm">
                            <button class="btn btn-primary btn-inverse" type="submit"  id="mg-button-save-settings"                
                                    <i class="glyphicon glyphicon-plus"></i>
                                {$MGLANG->T('button','Save Changes')}
                            </button>
                        </div>
                    </div>
                    <div role="tabpanel" class="tab-pane {if $showDomains != 1}active{/if}" id="mg-general">
                        <div class="alert alert-info">
                            {$MGLANG->T('Default nameservers, used if domain nameservers are not set.')}
                        </div>
                        <form action="" method="post" id="mg-settings-form" style="min-height:300px;" data-toggle="validator" role="form">
                            {$formGeneral}
                        </form> 
                        <div class="well well-sm">
                            <button class="btn btn-primary btn-inverse" type="submit"  id="mg-button-save"                
                                    <i class="glyphicon glyphicon-plus"></i>
                                {$MGLANG->T('button','Save Changes')}
                            </button>
                        </div>
                    </div>
                    <div role="tabpanel" class="tab-pane {if $showDomains}active{/if}" id="mg-domains">

                        <form action="" method="post" id="mg-domain-form" style="min-height:300px;" role="form">


                            <table class="table table-hover" id="mg-data-list" >
                                <thead>
                                    <tr>
                                        <th><input class="toggleAll" type="checkbox"></th>
                                        <th>{$MGLANG->T('tableHeader','TLD')}</th>
                                        <th>{$MGLANG->T('tableHeader','Domain Forwarding')}</th>
                                        <th>{$MGLANG->T('tableHeader','Subfolders Redirect')}</th>
                                        <th>{$MGLANG->T('tableHeader','Email Forwarding')}</th>
                                        <th style="width: 40px; text-align: center;">{$MGLANG->T('tableHeader','Action')}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                </tbody> 
                            </table>

                            <div class="well well-sm">
                                <button class="btn btn-primary btn-inverse" type="submit"  id="mg-domain-mass-edit"   disabled=""         
                                        <i class="glyphicon glyphicon-plus"></i>
                                    {$MGLANG->T('button','Edit')}
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            {*Modal mg-modal-domain-edit*} 
            <form data-toggle="validator" role="form" id="mg-form-domain-edit">
                <div class="modal fade bs-example-modal-lg modal-tabed" id="mg-modal-domain-edit" data-modal-load="domainDetail" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
                                <h4 class="modal-title">{$MGLANG->absoluteT('Edit:')} <strong data-modal-var="tld"></strong></h4>
                            </div>

                            <div class="modal-body">
                                <input type="hidden" name="id" data-target="id" value="">
                                <div class="modal-alerts">
                                    <div style="display:none;" data-prototype="error">
                                        <div class="note note-danger">
                                            <button type="button" class="close" data-dismiss="alert"><span aria-hidden="true">&times;</span><span class="sr-only"></span></button>
                                            <strong></strong>
                                            <a style="display:none;" class="errorID" href=""></a>
                                        </div>
                                    </div>
                                    <div style="display:none;" data-prototype="success">
                                        <div class="note note-success">
                                            <button type="button" class="close" data-dismiss="alert"><span aria-hidden="true">&times;</span><span class="sr-only"></span></button>
                                            <strong></strong>
                                        </div>
                                    </div>
                                </div>
                                <!-- Nav tabs -->
                                <ul class="nav nav-tabs" role="tablist">
                                    <li role="presentation" class="active"><a href="#mg-general-tab" aria-controls="mg-general-tab" role="tab" data-toggle="tab">
                                            {$MGLANG->T('General')}</a>
                                    </li>
                                    <li role="presentation"><a href="#mg-nameservers-tab" aria-controls="mg-nameservers-tab" role="tab" data-toggle="tab">
                                            {$MGLANG->T('Nameservers')}</a>
                                    </li>
                                </ul>
                                <!-- Tab panes -->
                                {$formDomainEdit}
                            </div>
                            <div class="modal-footer">
                                <button type="submit" class="btn btn-inverse btn-primary" data-modal-action="domainSave" id="pm-modal-addip-button-add">{$MGLANG->absoluteT('Save')}</button>
                                <button type="button" class="btn btn-inverse btn-default" data-dismiss="modal">{$MGLANG->absoluteT('Close')}</button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>    

            {*Modal mg-modal-domain-edit *}
            <form data-toggle="validator" role="form" id="mg-form-domain-mass-edit">
                <div class="modal fade bs-example-modal-lg modal-tabed" id="mg-modal-domain-mass-edit" data-modal-load="detailDomain" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
                                <h4 class="modal-title">{$MGLANG->absoluteT('Edit:')} <strong data-modal-var="tlds"></strong></h4>
                            </div>

                            <div class="modal-body">
                                <input type="hidden" name="id" id="mg-modal-domain-mass-edit-input-id" data-target="ids" value="">
                                <div class="modal-alerts">
                                    <div style="display:none;" data-prototype="error">
                                        <div class="note note-danger">
                                            <button type="button" class="close" data-dismiss="alert"><span aria-hidden="true">&times;</span><span class="sr-only"></span></button>
                                            <strong></strong>
                                            <a style="display:none;" class="errorID" href=""></a>
                                        </div>
                                    </div>
                                    <div style="display:none;" data-prototype="success">
                                        <div class="note note-success">
                                            <button type="button" class="close" data-dismiss="alert"><span aria-hidden="true">&times;</span><span class="sr-only"></span></button>
                                            <strong></strong>
                                        </div>
                                    </div>
                                </div>
                                <!-- Nav tabs -->
                                <ul class="nav nav-tabs" role="tablist">
                                    <li role="presentation" class="active"><a href="#mg-general-tab-mass" aria-controls="mg-general-tab" role="tab" data-toggle="tab">
                                            {$MGLANG->T('General')}</a>
                                    </li>
                                    <li role="presentation" class="active"><a href="#mg-nameservers-tab-mass" aria-controls="mg-nameservers-tab" role="tab" data-toggle="tab">
                                            {$MGLANG->T('Nameservers')}</a>
                                    </li>
                                </ul>
                                <!-- Tab panes -->
                                {$formDomainEditMass}
                            </div>
                            <div class="modal-footer">
                                <button type="submit" class="btn btn-primary"  id="mg-form-domain-mass-edit-save">{$MGLANG->absoluteT('Save')}</button>
                                <button type="button" class="btn btn-default" data-dismiss="modal">{$MGLANG->absoluteT('Close')}</button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>                      
        </div>
    </div>
</div>
{literal}
    <script type="text/javascript">
        jQuery(document).ready(function () {
            var mgDataTable;
            $('#mg-button-save').on('click', function (e) {
                if ($(this).hasClass('disabled'))
                    return;
                e.preventDefault();
                JSONParser.request(
                        'save'
                        , $('#mg-settings-form').serialize()
                        , function (data) {
                        }
                );
            });

            $('#mg-button-save-settings').on('click', function (e) {
                if ($(this).hasClass('disabled'))
                    return;
                e.preventDefault();
                JSONParser.request(
                        'saveSettings'
                        , $('#mg-settings-main-form').serialize()
                        , function (data) {
                        }
                );
            });


            $(document).on('click', '.toggleAll', function () {
                $('.checkThis').prop('checked', $(this).is(':checked'));
                $('.checkThis').trigger("change");
            });
            
            mgDataTable = $('#mg-data-list').dataTable({
                processing: false,
                searching: true,
                autoWidth: false,
                "serverSide": false,
                "order": [[1, "desc"]],
                ajax: function (data, callback, settings) {
                    JSONParser.request(
                            'domainSettingList'
                            , {
                                filter: {}
                                , limit: data.length
                                , offset: data.start
                                , order: data.order
                                , search: data.search
                            }
                    , function (data) {
                        callback(data);
                    }
                    );
                },
                'columns': [
                    {orderable: false},
                    null,
                    {orderable: false},
                    {orderable: false},
                    {orderable: false},
                    {orderable: false}

                ],
                'aoColumnDefs': [{
                        'bSortable': false,
                        'aTargets': ['nosort']
                    }],
                language: {
                    "lengthMenu": "{/literal}{$MGLANG->absoluteT('Show _MENU_ entries')}{literal}",
                    "info": "{/literal}{$MGLANG->absoluteT('Showing _START_ to _END_ of _TOTAL_ entries')}{literal}",
                    "zeroRecords": "{/literal}{$MGLANG->absoluteT('Nothing to display')}{literal}",
                    "infoEmpty": "",
                    "search": "{/literal}{$MGLANG->absoluteT('Search')}{literal}",
                    "paginate": {
                        "previous": "{/literal}{$MGLANG->absoluteT('Previous')}{literal}"
                        , "next": "{/literal}{$MGLANG->absoluteT('Next')}{literal}"
                    }
                }
            });

            jQuery('#mg-setting-content').MGModalActions();

            $('#mg-setting-content').on('mgeven.saved', function (e) {
                var api = mgDataTable.api();
                api.ajax.reload(function () {
                }, false);
            });

            //Mass edit
            $("#mg-domain-mass-edit").on('click', function (e) {
                e.preventDefault();
                JSONParser.request(
                        'domainDetails'
                        , $("#mg-domain-form").serialize()
                        , function (data) {
                            $("#mg-modal-domain-mass-edit .modal-title strong").text(data.tlds);
                            $("#mg-modal-domain-mass-edit").modal();
                            $("#mg-modal-domain-mass-edit").MGresetInputData();
                            $('.modal-alerts').alerts('clear');
                            $("[name='domains[submodule]']").val($("[name='domains[submodule]']").val()).trigger("change");
                        }
                );

            });

            $("#mg-form-domain-mass-edit-save").on('click', function (e) {
                e.preventDefault();
                JSONParser.request(
                        'domainsSave'
                        , $("#mg-domain-form").serialize() + "&" + $("#mg-form-domain-mass-edit").serialize()
                        , function (data) {
                            if (data.modalError)
                            {
                                $('.modal.in .modal-alerts').alerts('error', data.modalError);
                                return false;
                            }

                            $("#mg-modal-domain-mass-edit").modal("hide");
                            $(".toggleAll").prop('checked', false);
                            $("#mg-domain-mass-edit").prop("disabled", true);
                            var api = mgDataTable.api();
                            api.ajax.reload(function () {
                            }, false);
                        }
                );
            });

            $("#mg-domain-form").on("change", ".checkThis", function (e) {
                $("#mg-domain-mass-edit").prop("disabled", !$(this).is(":checked"));
            });

            //subfolders redirect 
            $('#mg-domains-urlForwarding input[type=checkbox][name="domains[urlForwarding][]"][value=urlForwarding]').change(function () {
                if ($(this).is(':checked')) {
                    $('#mg-domains-urlForwarding input[type=checkbox][name="domains[urlForwarding][]"][value=subfoldersRedirect]').closest('.checkbox').show();
                } else {
                    $('#mg-domains-urlForwarding input[type=checkbox][name="domains[urlForwarding][]"][value=subfoldersRedirect]').prop('checked', false);
                    $('#mg-domains-urlForwarding input[type=checkbox][name="domains[urlForwarding][]"][value=subfoldersRedirect]').closest('.checkbox').hide();
                }
            });

            $('#mg-domains-urlForwarding-mass input[type=checkbox][name="domains[urlForwarding][]"][value=urlForwarding]').change(function () {
                if ($(this).is(':checked')) {
                    $('#mg-domains-urlForwarding-mass input[type=checkbox][name="domains[urlForwarding][]"][value=subfoldersRedirect]').closest('.checkbox').show();
                } else {
                    $('#mg-domains-urlForwarding-mass input[type=checkbox][name="domains[urlForwarding][]"][value=subfoldersRedirect]').prop('checked', false);
                    $('#mg-domains-urlForwarding-mass input[type=checkbox][name="domains[urlForwarding][]"][value=subfoldersRedirect]').closest('.checkbox').hide();
                }
            });

            $('.modal-tabed').on('show.bs.modal', function (e) {
                $(this).find('.nav-tabs li').removeClass();
                $(this).find('li').first().addClass('active');
                $(this).find('.tab-content div').removeClass('active');
                $('#mg-general-tab, #mg-general-tab-mass').addClass('active');
            });

        });
    </script>
{/literal}