<?php

namespace MGModule\DomainAndEmailForwarding\submodules\cpanel;


/**
 * Description of Uapi
 *
 * @author Tomasz Bielecki <tomasz.bi@modulesgarden.com>
 */
class Uapi
{
    protected $ch            = false;
    protected $token         = false;
    protected $expires;
    protected $username;
    protected $password;
    protected $host;
    protected $port;
    protected $accessHeader;
    protected $ssl;
    protected $sessionUrl;
    protected $queryuser;
    protected $curlCustomConfig;
    private static $instance = false;

    public static function getInstance($host, $username, $password = null, $queryuser, $ssl = true, $hash = null, $port = null)
    {
        if (self::$instance === false || self::$instance->queryuser !== $queryuser)
        {
            self::$instance = new self($host, $username, $password, $queryuser, $ssl, $hash, $port);
        }

        return self::$instance;
    }

    protected function __construct($host, $username, $password, $queryuser, $ssl, $hash = null, $port = null)
    {
        $this->host         = $host; // : $params['serverip']; //brak adresu ip
        $this->username     = $username;
        $this->password     = $password;
        $this->accessHeader = "Authorization: Basic " . base64_encode($this->username . ":" . $this->password);
        $this->ssl          = $ssl;
        $this->port         = $port;
        if (!$port) {
            $this->port     = $this->ssl == true ? '2087' : '2086';
        }
        $this->queryuser    = $queryuser;

        $this->initiateConnection();
    }

    protected function initiateConnection()
    {
        $sessionDetails = $this->getSessionDetails();

        $decodedResponse = json_decode($sessionDetails, true);

        if (!$decodedResponse)
        {
            $this->ch = false;
            return false;
        }
        $this->setSessionDetails($decodedResponse);
    }

    protected function getSessionDetails()
    {
        $query    = ($this->ssl ? 'https' : 'http') . "://" . $this->host . ":" . $this->port
                . "/json-api/create_user_session?api.version=1&user=" . $this->queryuser . "&service=cpaneld";
        $this->ch = curl_init();

        curl_setopt($this->ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($this->ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($this->ch, CURLOPT_HEADER, false);
        curl_setopt($this->ch, CURLOPT_RETURNTRANSFER, true);
        $header[0] = $this->accessHeader;
        curl_setopt($this->ch, CURLOPT_HTTPHEADER, $header);
        curl_setopt($this->ch, CURLOPT_URL, $query);
        $result    = curl_exec($this->ch);

        if ($result == false)
        {
            if (curl_error($this->ch) == 'connect() timed out!')
            {
                throw new CPanelException('Could not connect to the server. Please try again later or contact administrator.');
            }
            throw new CPanelException(curl_error($this->ch));
        }

        return $result;
    }

    protected function setSessionDetails($decodedResponse)
    {
        if(!isset($decodedResponse['data']['url']))
        {
            if(isset($decodedResponse['metadata']['result']) && $decodedResponse['metadata']['result'] == 0)
            {
                throw new CPanelException($decodedResponse['metadata']['reason']);
            }
            else
            {
                throw new CPanelException('Could not connect to the server. Please try again later or contact administrator.');
            }
        }
        
        $tab = explode(':', $decodedResponse['data']['url']);

        $sessionUrl = $tab[0] . '://' . $this->host . ':' . $tab[2];
        $cookieJar  = 'cookie.txt';

        curl_setopt($this->ch, CURLOPT_HTTPHEADER, null);
        curl_setopt($this->ch, CURLOPT_COOKIESESSION, true);
        curl_setopt($this->ch, CURLOPT_COOKIEJAR, $cookieJar);
        curl_setopt($this->ch, CURLOPT_COOKIEFILE, $cookieJar);
        curl_setopt($this->ch, CURLOPT_URL, $sessionUrl);

        $result = curl_exec($this->ch);

        if ($result == false)
        {
            if (curl_error($this->ch) == 'connect() timed out!')
            {
                throw new CPanelException('Could not connect to the server. Please try again later or contact administrator.');
            }

            throw new CPanelException(curl_error($this->ch));
        }
        $this->sessionUrl = preg_replace('{/login(?:/)??.*}', '', $sessionUrl);
    }

    protected function exec($name, $api, $params = array())
    {
        $query = $this->sessionUrl . $api . $name;


        curl_setopt($this->ch, CURLOPT_URL, $query);
        $result = curl_exec($this->ch);

        if ($result == false)
        {
            throw new CPanelException("Could not connect to the server. Please try again later or contact administrator.");
        }

        $resp = json_decode($result);

        return $resp;
    }

    public function execQuery($end)
    {

        return $this->exec($name   = null, $end, $params = null);
    }
}
