<?php

/* * ********************************************************************
 * DiscountCenter product developed. (2015-11-17)
 * *
 *
 *  CREATED BY MODULESGARDEN       ->       http://modulesgarden.com
 *  CONTACT                        ->       contact@modulesgarden.com
 *
 *
 * This software is furnished under a license and may be used and copied
 * only  in  accordance  with  the  terms  of such  license and with the
 * inclusion of the above copyright notice.  This software  or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person.  No title to and  ownership of the  software is  hereby
 * transferred.
 *
 *
 * ******************************************************************** */

namespace MGModule\DomainAndEmailForwarding\models;

use MGModule\DomainAndEmailForwarding as main;

/**
 * Description of Configuration
 *
 * @author Pawel Kopec <pawelk@modulesgarden.com>
 * @Table(name=settings)
 */
class Registry extends main\mgLibs\models\Orm
{
    private $_configurationArray = array();
    private static $instance;

    public function __construct()
    {

        if (empty(self::$instance))
            $this->load();
    }

    /**
     * 
     * @return Registry
     */
    public static function getInstance()
    {
        if (!empty(self::$instance))
            return self::$instance;
        return self::$instance = new self();
    }

    protected function load()
    {
        $result = main\mgLibs\MySQL\Query::select(
                        array('setting', 'value')
                        , self::tableName()
        );
        while ($row    = $result->fetch())
        {
            $this->_configurationArray[$row['setting']] = $row['value'];
        }
    }

    public function set($key, $value)
    {
        if (empty($key))
            throw new main\mgLibs\exceptions\System("Invalid argument. Key is empty");
        $this->_configurationArray[$key] = $value;
    }

    public function get($name = null)
    {

        return $name === null ? $this->_configurationArray : $this->_configurationArray[$name];
    }

    public function __isset($name)
    {
        return isset(self::$this->_configurationArray[$name]);
    }

    public function save($data = array())
    {


        if (!empty($data))
        {
            foreach ($data as $key => $value)
                $this->set($key, $value);
        }
        $tab = self::tableName();
        foreach ($this->_configurationArray as $key => $value)
        {
            $query = "INSERT INTO `$tab` ( `setting`,`value`) VALUES (:key,:value)
                      ON DUPLICATE KEY UPDATE   `value`=VALUES(`value`)";
            main\mgLibs\MySQL\Query::query($query, array("key" => $key, "value" => $value));
        }
    }

    public function isDebug()
    {
        return $this->get('debug') == "1";
    }

    public function getEnabledHosting()
    {
        return $this->get('enable_hosting');
    }

    public function getNameserver1()
    {
        return $this->get('nameserver1');
    }

    public function getNameserver2()
    {
        return $this->get('nameserver2');
    }

    public function getNameserver3()
    {
        return $this->get('nameserver3');
    }

    public function getNameserver4()
    {
        return $this->get('nameserver4');
    }

    public function getNameserver5()
    {
        return $this->get('nameserver5');
    }

    public function getNameservers()
    {
        return array(
            $this->get('nameserver1'),
            $this->get('nameserver2'),
            $this->get('nameserver3'),
            $this->get('nameserver4'),
            $this->get('nameserver5')
        );
    }
}
