<?php

/* * ********************************************************************
 * QuickBooksDesktop product developed. (2016-01-12)
 * *
 *
 *  CREATED BY MODULESGARDEN       ->       http://modulesgarden.com
 *  CONTACT                        ->       contact@modulesgarden.com
 *
 *
 * This software is furnished under a license and may be used and copied
 * only  in  accordance  with  the  terms  of such  license and with the
 * inclusion of the above copyright notice.  This software  or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person.  No title to and  ownership of the  software is  hereby
 * transferred.
 *
 *
 * ******************************************************************** */

namespace MGModule\DomainAndEmailForwarding\models;

use MGModule\DomainAndEmailForwarding as main;

/**
 * Description of Log
 *
 * @author Pawel Kopec <pawelk@modulesgarden.com>
 * @Table(name=logs)
 */
class Log extends main\mgLibs\models\Orm
{
    /**
     * ID field
     * 
     * @Column(id)
     * @var int 
     */
    protected $id;

    /**
     * @Column(text,name=message)
     * @var string
     */
    protected $message;

    /**
     * @Column(int,name=status)
     * @var int
     */
    protected $status;

    /**
     * @Column(datetime,name=date)
     * @var string
     */
    protected $date;

    public function getId()
    {
        return $this->id;
    }

    public function getMessage()
    {
        return $this->message;
    }

    public function getStatus()
    {
        return $this->status;
    }

    public function getDate()
    {
        return $this->date;
    }

    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }

    public function setMessage($message)
    {
        $this->message = $message;
        return $this;
    }

    public function setStatus($status)
    {
        $this->status = $status;
        return $this;
    }

    public function setDate()
    {
        $this->date = $this->timeStamp();
        return $this;
    }

    public static function success($message)
    {
        $log = new self();
        $log->setMessage($message)
                ->setDate()
                ->setStatus(1)
                ->save();
    }

    public static function error($message)
    {
        $log = new self();
        $log->setMessage($message)
                ->setDate()
                ->setStatus(0)
                ->save();
    }
}
