<?php

namespace MGModule\DomainAndEmailForwarding\mgLibs\helpers;


use MGModule\DomainAndEmailForwarding\mgLibs\MySQL\Query;
use MGModule\DomainAndEmailForwarding\mgLibs\exceptions\System;
/**
 * Class DNSManager
 *
 * @author Artur Pilch <artur.pi@modulesgarden.com>
 */
class DNSManager
{
    CONST DNS_MANAGER = 'DNSManager2';

    public static function getZone($domain)
    {

        if(!self::isDnsManagerModuleActive())
        {
            return;
        }
        $zone = self::isSubModuleEnableForDomain($domain);
        if (!empty($zone))
        {
            throw new System("This domain has enabled DNS Manager zone");
        }
        return $zone;
    }

    public static function isDnsManagerModuleActive()
    {
        $result = Query::query("SELECT count(*) AS isActive FROM tbladdonmodules WHERE module = 'DNSManager2'")->fetch();
        return $result['isActive'];
    }

    public static function isSubModuleEnableForDomain($domain)
    {
        return Query::query("SELECT z.name
                    FROM dns_manager2_zone AS z
                    LEFT JOIN dns_manager2_server AS s ON z.serverid = s.id
                    WHERE s.module IN('CPanel', 'CPanelOldApi', 'DirectAdmin') AND z.name LIKE '{$domain}'")->fetch();
    }
}