<?php

/* * ********************************************************************
 * DiscountCenter product developed. (2015-11-16)
 * *
 *
 *  CREATED BY MODULESGARDEN       ->       http://modulesgarden.com
 *  CONTACT                        ->       contact@modulesgarden.com
 *
 *
 * This software is furnished under a license and may be used and copied
 * only  in  accordance  with  the  terms  of such  license and with the
 * inclusion of the above copyright notice.  This software  or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person.  No title to and  ownership of the  software is  hereby
 * transferred.
 *
 *
 * ******************************************************************** */


namespace MGModule\DomainAndEmailForwarding\controllers\addon\admin;

use MGModule\DomainAndEmailForwarding as main;

/**
 * Domains management (park/unpark/check)
 *
 * @author Mateusz Tomaszewski <mateusz.to@modulesgarden.com>
 */
class Api
{

    function indexHTML($input, $vars = array())
    {
        global $CONFIG;
        $apiPoint = $CONFIG['SystemURL'].'/modules/addons/DomainAndEmailForwarding/api';
        $vars['apiPoint'] = $apiPoint;
        return array(
            'tpl'  => 'api'
            , 'vars' => $vars
        );
    }
    
    public function ipAdressValidate($ip)
    {
        if (filter_var($ip, FILTER_VALIDATE_IP) || strlen($ip) == 0)
        {
            return true;
        }
        return false;
    }
    
    function multiexplode ($delimiters,$string)
    {
        $ready = str_replace($delimiters, $delimiters[0], $string);
        $launch = explode($delimiters[0], $ready);
        return  $launch;
    }
    
    
    public function searchWhiteSpaces($text)
    {
        $breaks = nl2br($text);
        $explode = $this->multiexplode( array('<br />', ","), $breaks);

        foreach ($explode as $ip)
        {
            if(!$this->ipAdressValidate(trim($ip)))
                return false;  
        }
        return true;
    }
    
    
    public function addTokenJSON($input, $vars = array())
    {
        $ip = isset($input['add']['enabledips']) ? $input['add']['enabledips'] : $input['edit']['enabledips'] ;
        $correct = $this->searchWhiteSpaces($ip);
        if(!$correct)
        {
           return array (
                'error' => sprintf(main\mgLibs\lang::T("IPnotValid")),
               );
        }
        $nameExist = \MGModule\DomainAndEmailForwarding\mgLibs\MySQL\Query::select(array('name'), 'mgdomforw_tokenAccess', array('name' => $input['add']['tokenName']))->fetchColumn();
        if($nameExist){
            return array (
                'error' => sprintf(main\mgLibs\lang::T("Such name exist")),
               );
        }
        $entity = new main\models\TokenAccess();
        if($input['id'])
        {
            $msg = 'Token has been updated';
            $entity = new main\models\TokenAccess($input['id']);
            $entity->setIp($input['edit']['enabledips']);
        
        }
        else 
        {
            $msg = 'Token has been added';
            $entity->setName($input['add']['tokenName']);
            $entity->setToken($input['generatedToken']);
            
            $entity->setIp($input['add']['enabledips']);
        }
        $entity->save();
        return array(
           'success' => sprintf(main\mgLibs\lang::T($msg))
        );
    }
    
    public function accessTokenListJSON($input, $vars = array())
    {
        $repository = new main\repository\TokenAccessRepository();
        $data       = array();
        foreach ($repository->fetch() as $entity)
        {
            $data[] = $this->_formatDomainSettingRow($entity);
        }
        return array(
            'data'            => $data
            , 'recordsTotal'    => count($data)
            , 'recordsFiltered' => count($data)
        );
    }
    
    private function _formatDomainSettingRow(main\models\TokenAccess $entity)
    {
        return array(
            'DT_RowData' => array('id' => $entity->getId()),
            $entity->getName(),
            $entity->getToken(),
            main\mgLibs\Smarty::I()->view('actionToken', array("entity" => $entity->toArray(false)))
        );
    }
    
    public function tokenDeleteDetailJSON($input, $vars = array())
    {
        $enitity = \MGModule\DomainAndEmailForwarding\mgLibs\MySQL\Query::select(array('name'), 'mgdomforw_tokenAccess', array('id' => $input['id']))->fetch();
        return array(
          'vars' => array(
            'tokenName' => $enitity['name'],
          )
        );
    }
    
    public function deleteTokenJSON($input, $vars = array())
    {
        $token = new \MGModule\DomainAndEmailForwarding\models\TokenAccess($input['id']);
        $token->delete();
        return array('success' => sprintf(main\mgLibs\lang::T('Token has been deleted')));
    }
    
    public function tokenEditDetailJSON ($input, $vars = array()){


        $enitity = \MGModule\DomainAndEmailForwarding\mgLibs\MySQL\Query::select(array('name', 'token', 'ips'), 'mgdomforw_tokenAccess', array('id' => $input['id']))->fetch();
        return array(
          'vars' => array(
                'tokenName' => $enitity['name'],
                'tokenCode' => $enitity['token'],  
                'tokenIPs'  => $enitity['ips'],
          )  
        );
    }
    
}
