<?php 

namespace MGModule\DomainAndEmailForwarding\api;

require_once dirname(dirname(dirname(dirname(__DIR__)))).'/init.php';
require_once 'AltoRouter.php';
require_once dirname(__DIR__).'/Loader.php';
require_once __DIR__.'/controller/Api.php';

use MGModule\DomainAndEmailForwarding as main;
use MGModule\DomainAndEmailForwarding\Loader as Loader;
use api\controller\Api as ApiController;
use api\AltoRouter as Router;


$loader = new Loader();
$altoRouter = new Router();

$dirScript =  substr($_SERVER['SCRIPT_NAME'], 0, strpos($_SERVER['SCRIPT_NAME'],basename($_SERVER['SCRIPT_NAME'])));


$altoRouter->setBasePath($_SERVER['REQUEST_SCHEME'].'://'.$_SERVER['SERVER_NAME']. $dirScript);

//services
$altoRouter->map('GET', 'user/[i:id]/services', function ($id){
    ApiController::I()->API('userServices', array('id' => $id));
});
//emails
$altoRouter->map('GET', 'services/[i:domain_id]/emailsRedirects', function ($domain_id){
    ApiController::I()->API('emailRedirectsForService', array(
            'domainId' => $domain_id,
        ));
});

$altoRouter->map('POST', 'services/[i:domain_id]/emailsRedirects/delete', function ($domain_id){
    ApiController::I()->API('deleteEmailRedirectsForService', array(
            'domainId' => $domain_id,
        ));
});

$altoRouter->map('POST', 'services/[i:domain_id]/emailsRedirects', function ($domain_id){
    ApiController::I()->API('createEmailRedirectsForService', array(
            'domainId' => $domain_id,
        ));
});

//redircts
$altoRouter->map('GET', 'services/[i:domain_id]/domainsRedirects', function ($domain_id){
    ApiController::I()->API('domainRedirectsForService', array(
            'domainId' => $domain_id,
        ));
});

$altoRouter->map('POST', 'services/[i:domain_id]/domainsRedirects', function ($domain_id){
    ApiController::I()->API('createDomainRedirectsForService', array(
            'domainId' => $domain_id,
        ));
});

$altoRouter->map('POST', 'services/[i:domain_id]/domainsRedirects/delete', function ($domain_id){
    ApiController::I()->API('deleteDomainRedirectsForService', array(
            'domainId' => $domain_id,
        ));
});

$match = $altoRouter->match();

if( $match && is_callable( $match['target'] ) ) {
     call_user_func_array( $match['target'], $match['params'] ); 
} 
else
{
    header( $_SERVER["SERVER_PROTOCOL"] . ' 404 Not Found');
}

