/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jcterm;

import com.jcraft.jcterm.Connection;
import com.jcraft.jcterm.Emulator;
import com.jcraft.jcterm.EmulatorVT100;
import com.jcraft.jcterm.Splash;
import com.jcraft.jcterm.Term;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.InputStream;
import java.io.OutputStream;

public class JCTermAWT
extends Panel
implements KeyListener,
Term {
    static String COPYRIGHT = "JCTerm 0.0.10\nCopyright (C) 2002,2007 ymnk<ymnk@jcraft.com>, JCraft,Inc.\nOfficial Homepage: http://www.jcraft.com/jcterm/\nThis software is licensed under GNU LGPL.";
    private OutputStream out;
    private InputStream in;
    Emulator emulator = null;
    Connection connection = null;
    private Image img;
    private Graphics cursor_graphics;
    private Graphics graphics;
    private Color defaultbground = Color.black;
    private Color defaultfground = Color.white;
    private Color bground = Color.black;
    private Color fground = Color.white;
    private Component term_area = null;
    private Font font;
    private boolean bold = false;
    private boolean underline = false;
    private boolean reverse = false;
    private int term_width = 80;
    private int term_height = 24;
    private int x = 0;
    private int y = 0;
    private int descent = 0;
    private int char_width;
    private int char_height;
    private boolean antialiasing = true;
    private int line_space = -2;
    private int compression = 0;
    private Splash splash = null;
    private final Object[] colors = new Object[]{Color.black, Color.red, Color.green, Color.yellow, Color.blue, Color.magenta, Color.cyan, Color.white};
    private Thread thread = null;
    byte[] obuffer = new byte[3];

    public JCTermAWT() {
        this.enableEvents(8L);
    }

    private void setFont(String fname) {
        this.font = Font.decode(fname);
        Image img = this.createImage(1, 1);
        Graphics graphics = img.getGraphics();
        graphics.setFont(this.font);
        FontMetrics fo = graphics.getFontMetrics();
        this.descent = fo.getDescent();
        this.char_width = fo.charWidth('@');
        this.char_height = fo.getHeight() + this.line_space * 2;
        img.flush();
        graphics.dispose();
    }

    void initGraphics() {
        this.setFont("Monospaced-14");
        this.img = this.createImage(this.getTermWidth(), this.getTermHeight());
        this.graphics = this.img.getGraphics();
        this.graphics.setFont(this.font);
        if (this.splash != null) {
            this.splash.draw(this.img, this.getTermWidth(), this.getTermHeight());
        } else {
            this.clear();
        }
        this.cursor_graphics = this.img.getGraphics();
        this.cursor_graphics.setColor(this.getForeGround());
        this.cursor_graphics.setXORMode(this.getBackGround());
        this.term_area = this;
        JCTermAWT panel = this;
        panel.setSize(this.getTermWidth(), this.getTermHeight());
        panel.setFocusable(true);
    }

    public void setFrame(Component term_area) {
        this.term_area = term_area;
    }

    @Override
    public void start(Connection connection) {
        this.connection = connection;
        this.in = connection.getInputStream();
        this.out = connection.getOutputStream();
        this.emulator = new EmulatorVT100(this, this.in);
        this.emulator.reset();
        this.emulator.start();
        if (this.splash != null) {
            this.splash.draw(this.img, this.getTermWidth(), this.getTermHeight());
        } else {
            this.clear();
        }
        this.redraw(0, 0, this.getTermWidth(), this.getTermHeight());
    }

    @Override
    public void update(Graphics g) {
        if (this.img == null) {
            this.initGraphics();
        }
        g.drawImage(this.img, 0, 0, this.term_area);
    }

    @Override
    public void paint(Graphics g) {
        if (this.img == null) {
            this.initGraphics();
        }
        g.drawImage(this.img, 0, 0, this.term_area);
    }

    @Override
    public void processKeyEvent(KeyEvent e) {
        int id = e.getID();
        if (id == 401) {
            this.keyPressed(e);
        } else if (id != 402 && id == 400) {
            this.keyTyped(e);
        }
        e.consume();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int keycode = e.getKeyCode();
        byte[] code = null;
        switch (keycode) {
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                return;
            }
            case 10: {
                code = this.emulator.getCodeENTER();
                break;
            }
            case 38: {
                code = this.emulator.getCodeUP();
                break;
            }
            case 40: {
                code = this.emulator.getCodeDOWN();
                break;
            }
            case 39: {
                code = this.emulator.getCodeRIGHT();
                break;
            }
            case 37: {
                code = this.emulator.getCodeLEFT();
                break;
            }
            case 112: {
                code = this.emulator.getCodeF1();
                break;
            }
            case 113: {
                code = this.emulator.getCodeF2();
                break;
            }
            case 114: {
                code = this.emulator.getCodeF3();
                break;
            }
            case 115: {
                code = this.emulator.getCodeF4();
                break;
            }
            case 116: {
                code = this.emulator.getCodeF5();
                break;
            }
            case 117: {
                code = this.emulator.getCodeF6();
                break;
            }
            case 118: {
                code = this.emulator.getCodeF7();
                break;
            }
            case 119: {
                code = this.emulator.getCodeF8();
                break;
            }
            case 120: {
                code = this.emulator.getCodeF9();
                break;
            }
            case 121: {
                code = this.emulator.getCodeF10();
                break;
            }
            case 9: {
                code = this.emulator.getCodeTAB();
            }
        }
        if (code != null) {
            try {
                this.out.write(code, 0, code.length);
                this.out.flush();
            }
            catch (Exception ee) {
                // empty catch block
            }
            return;
        }
        char keychar = e.getKeyChar();
        if ((keychar & 0xFF00) == 0) {
            this.obuffer[0] = (byte)e.getKeyChar();
            try {
                this.out.write(this.obuffer, 0, 1);
                this.out.flush();
            }
            catch (Exception ee) {
                // empty catch block
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        char keychar = e.getKeyChar();
        if ((keychar & 0xFF00) != 0) {
            char[] foo = new char[]{keychar};
            try {
                byte[] goo = new String(foo).getBytes("EUC-JP");
                this.out.write(goo, 0, goo.length);
                this.out.flush();
            }
            catch (Exception eee) {
                // empty catch block
            }
        }
    }

    @Override
    public int getTermWidth() {
        return this.char_width * this.term_width;
    }

    @Override
    public int getTermHeight() {
        return this.char_height * this.term_height;
    }

    @Override
    public int getCharWidth() {
        return this.char_width;
    }

    @Override
    public int getCharHeight() {
        return this.char_height;
    }

    @Override
    public int getColumnCount() {
        return this.term_width;
    }

    @Override
    public int getRowCount() {
        return this.term_height;
    }

    @Override
    public void clear() {
        this.graphics.setColor(this.getBackGround());
        this.graphics.fillRect(0, 0, this.char_width * this.term_width, this.char_height * this.term_height);
        this.graphics.setColor(this.getForeGround());
    }

    @Override
    public void setCursor(int x, int y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public void draw_cursor() {
        this.cursor_graphics.fillRect(this.x, this.y - this.char_height, this.char_width, this.char_height);
        this.repaint(this.x, this.y - this.char_height, this.char_width, this.char_height);
    }

    @Override
    public void redraw(int x, int y, int width, int height) {
        this.repaint(x, y, width, height);
    }

    @Override
    public void clear_area(int x1, int y1, int x2, int y2) {
        this.graphics.setColor(this.getBackGround());
        this.graphics.fillRect(x1, y1, x2 - x1, y2 - y1);
        this.graphics.setColor(this.getForeGround());
    }

    @Override
    public void scroll_area(int x, int y, int w, int h, int dx, int dy) {
        this.graphics.copyArea(x, y, w, h, dx, dy);
    }

    @Override
    public void drawBytes(byte[] buf, int s, int len, int x, int y) {
        this.graphics.drawBytes(buf, s, len, x, y - (this.descent + this.line_space));
        if (this.bold) {
            this.graphics.drawBytes(buf, s, len, x + 1, y - (this.descent + this.line_space));
        }
        if (this.underline) {
            // empty if block
        }
    }

    @Override
    public void drawString(String str, int x, int y) {
        this.graphics.drawString(str, x, y - (this.descent + this.line_space));
        if (this.bold) {
            this.graphics.drawString(str, x + 1, y - (this.descent + this.line_space));
        }
        if (this.underline) {
            // empty if block
        }
    }

    @Override
    public void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    @Override
    public void keyReleased(KeyEvent event) {
    }

    public void setSplash(Splash foo) {
        this.splash = foo;
    }

    public void setLineSpace(int foo) {
        this.line_space = foo;
    }

    public void setCompression(int compression) {
        if (compression < 0 || 9 < compression) {
            return;
        }
        this.compression = compression;
    }

    public int getCompression() {
        return this.compression;
    }

    private Color toColor(Object o) {
        if (o instanceof String) {
            return Color.getColor((String)o);
        }
        if (o instanceof Color) {
            return (Color)o;
        }
        return Color.white;
    }

    @Override
    public void setDefaultForeGround(Object f) {
        this.defaultfground = this.toColor(f);
    }

    @Override
    public void setDefaultBackGround(Object f) {
        this.defaultbground = this.toColor(f);
    }

    @Override
    public void setForeGround(Object f) {
        this.fground = this.toColor(f);
        this.graphics.setColor(this.getForeGround());
    }

    @Override
    public void setBackGround(Object b) {
        this.bground = this.toColor(b);
    }

    private Color getForeGround() {
        if (this.reverse) {
            return this.bground;
        }
        return this.fground;
    }

    private Color getBackGround() {
        if (this.reverse) {
            return this.fground;
        }
        return this.bground;
    }

    @Override
    public Object getColor(int index) {
        if (this.colors == null || index < 0 || this.colors.length <= index) {
            return null;
        }
        return this.colors[index];
    }

    @Override
    public void setBold() {
        this.bold = true;
    }

    @Override
    public void setUnderline() {
        this.underline = true;
    }

    @Override
    public void setReverse() {
        this.reverse = true;
        if (this.graphics != null) {
            this.graphics.setColor(this.getForeGround());
        }
    }

    @Override
    public void resetAllAttributes() {
        this.bold = false;
        this.underline = false;
        this.reverse = false;
        this.bground = this.defaultbground;
        this.fground = this.defaultfground;
        if (this.graphics != null) {
            this.graphics.setColor(this.getForeGround());
        }
    }
}

